/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.accessagg;

import com.espertech.esper.core.service.StatementExtensionSvcContext;
import com.espertech.esper.epl.agg.access.AggregationStateMinMaxByEverSpecForge;
import com.espertech.esper.epl.agg.access.AggregationStateSortedSpecForge;
import com.espertech.esper.epl.agg.service.common.AggregationStateFactoryForge;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionSortedMinMaxByNode;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import java.util.Comparator;

public class SortedAggregationStateFactoryFactory {
    private final EngineImportService engineImportService;
    private final StatementExtensionSvcContext statementExtensionSvcContext;
    private final ExprNode[] expressions;
    private final boolean[] sortDescending;
    private final boolean ever;
    private final int streamNum;
    private final ExprAggMultiFunctionSortedMinMaxByNode parent;
    private final ExprForge optionalFilter;
    private final boolean join;

    public SortedAggregationStateFactoryFactory(EngineImportService engineImportService, StatementExtensionSvcContext statementExtensionSvcContext, ExprNode[] expressions, boolean[] sortDescending, boolean ever, int streamNum, ExprAggMultiFunctionSortedMinMaxByNode parent, ExprForge optionalFilter, boolean join) {
        this.engineImportService = engineImportService;
        this.statementExtensionSvcContext = statementExtensionSvcContext;
        this.expressions = expressions;
        this.sortDescending = sortDescending;
        this.ever = ever;
        this.streamNum = streamNum;
        this.parent = parent;
        this.optionalFilter = optionalFilter;
        this.join = join;
    }

    public AggregationStateFactoryForge makeForge() {
        boolean sortUsingCollator = this.engineImportService.isSortUsingCollator();
        Comparator<Object> comparator = ExprNodeUtilityCore.getComparatorHashableMultiKeys(this.expressions, sortUsingCollator, this.sortDescending);
        if (this.ever) {
            AggregationStateMinMaxByEverSpecForge spec = new AggregationStateMinMaxByEverSpecForge(this.streamNum, this.expressions, this.parent.isMax(), comparator, null, this.optionalFilter);
            return this.engineImportService.getAggregationFactoryFactory().makeMinMaxEver(this.statementExtensionSvcContext, this.parent, spec);
        }
        AggregationStateSortedSpecForge spec = new AggregationStateSortedSpecForge(this.streamNum, this.expressions, comparator, null, this.optionalFilter, this.join);
        return this.engineImportService.getAggregationFactoryFactory().makeSorted(this.statementExtensionSvcContext, this.parent, spec);
    }
}

