/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamExprDesc;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamPropDesc;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ExprNodePropOrStreamSet {
    private Set<ExprNodePropOrStreamPropDesc> properties;
    private List<ExprNodePropOrStreamExprDesc> expressions;

    public void add(ExprNodePropOrStreamDesc desc) {
        if (desc instanceof ExprNodePropOrStreamPropDesc) {
            this.allocateProperties();
            this.properties.add((ExprNodePropOrStreamPropDesc)desc);
        } else if (desc instanceof ExprNodePropOrStreamExprDesc) {
            this.allocateExpressions();
            this.expressions.add((ExprNodePropOrStreamExprDesc)desc);
        }
    }

    public void addAll(List<ExprNodePropOrStreamDesc> propertiesNode) {
        for (ExprNodePropOrStreamDesc desc : propertiesNode) {
            this.add(desc);
        }
    }

    public void addAll(ExprNodePropOrStreamSet other) {
        if (other.properties != null) {
            this.allocateProperties();
            this.properties.addAll(other.properties);
        }
        if (other.expressions != null) {
            this.allocateExpressions();
            this.expressions.addAll(other.expressions);
        }
    }

    public boolean isEmpty() {
        return !(this.properties != null && !this.properties.isEmpty() || this.expressions != null && !this.expressions.isEmpty());
    }

    public void removeFromList(List<ExprNodePropOrStreamDesc> items) {
        Iterator<ExprNodePropOrStreamDesc> item = items.iterator();
        while (item.hasNext()) {
            if (!this.findItem(item.next())) continue;
            item.remove();
        }
    }

    public String notContainsAll(ExprNodePropOrStreamSet other) {
        boolean found;
        if (other.properties != null) {
            for (ExprNodePropOrStreamPropDesc otherProp : other.properties) {
                found = this.findItem(otherProp);
                if (found) continue;
                return otherProp.getTextual();
            }
        }
        if (other.expressions != null) {
            for (ExprNodePropOrStreamExprDesc otherExpr : other.expressions) {
                found = this.findItem(otherExpr);
                if (found) continue;
                return otherExpr.getTextual();
            }
        }
        return null;
    }

    public Collection<ExprNodePropOrStreamPropDesc> getProperties() {
        if (this.properties == null) {
            return Collections.emptyList();
        }
        return this.properties;
    }

    public ExprNodePropOrStreamExprDesc getFirstExpression() {
        if (this.expressions == null || this.expressions.isEmpty()) {
            return null;
        }
        return this.expressions.get(0);
    }

    public ExprNodePropOrStreamDesc getFirstWithStreamNumNotZero() {
        if (this.properties != null) {
            for (ExprNodePropOrStreamPropDesc prop : this.properties) {
                if (prop.getStreamNum() == 0) continue;
                return prop;
            }
        }
        if (this.expressions != null) {
            for (ExprNodePropOrStreamExprDesc expr : this.expressions) {
                if (expr.getStreamNum() == 0) continue;
                return expr;
            }
        }
        return null;
    }

    private void allocateProperties() {
        if (this.properties == null) {
            this.properties = new HashSet<ExprNodePropOrStreamPropDesc>();
        }
    }

    private void allocateExpressions() {
        if (this.expressions == null) {
            this.expressions = new ArrayList<ExprNodePropOrStreamExprDesc>(4);
        }
    }

    private boolean findItem(ExprNodePropOrStreamDesc item) {
        if (item instanceof ExprNodePropOrStreamPropDesc) {
            return this.properties != null && this.properties.contains(item);
        }
        if (this.expressions == null) {
            return false;
        }
        ExprNodePropOrStreamExprDesc exprItem = (ExprNodePropOrStreamExprDesc)item;
        for (ExprNodePropOrStreamExprDesc expression : this.expressions) {
            if (expression.getStreamNum() != exprItem.getStreamNum() || !ExprNodeUtilityCore.deepEquals(expression.getOriginator(), exprItem.getOriginator(), false)) continue;
            return true;
        }
        return false;
    }
}

