/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.type.FrequencyParameter;
import com.espertech.esper.type.IntParameter;
import com.espertech.esper.type.ListParameter;
import com.espertech.esper.type.NumberSetParameter;
import com.espertech.esper.type.RangeParameter;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNumberSetList
extends ExprNodeBase
implements ExprForge,
ExprEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExprNumberSetList.class);
    private static final String METHOD_HANDLEEXPRNUMBERSETLISTADD = "handleExprNumberSetListAdd";
    private static final String METHOD_HANDLEEXPRNUMBERSETLISTEMPTY = "handleExprNumberSetListEmpty";
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = 4941618470342360450L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return ListParameter.class;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        writer.append('[');
        Iterator<ExprNode> it = Arrays.asList(this.getChildNodes()).iterator();
        do {
            ExprNode expr = it.next();
            writer.append(delimiter);
            expr.toEPL(writer, ExprPrecedenceEnum.MINIMUM);
            delimiter = ",";
        } while (it.hasNext());
        writer.append(']');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean isConstantResult() {
        for (ExprNode child : this.getChildNodes()) {
            if (child.isConstantResult()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprNumberSetList;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(this.getChildNodes());
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            Class type = this.getChildNodes()[i].getForge().getEvaluationType();
            if (type == FrequencyParameter.class || type == RangeParameter.class || JavaClassHelper.isNumericNonFP(type)) continue;
            throw new ExprValidationException("Frequency operator requires an integer-type parameter");
        }
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayList<NumberSetParameter> parameters = new ArrayList<NumberSetParameter>();
        for (ExprEvaluator child : this.evaluators) {
            Object value = child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            ExprNumberSetList.handleExprNumberSetListAdd(value, parameters);
        }
        ExprNumberSetList.handleExprNumberSetListEmpty(parameters);
        return new ListParameter(parameters);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(ListParameter.class, ExprNumberSetList.class, codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(List.class, "parameters", CodegenExpressionBuilder.newInstance(ArrayList.class, new CodegenExpression[0]));
        int count = -1;
        for (ExprNode node : this.getChildNodes()) {
            ExprForge forge = node.getForge();
            Class evaluationType = forge.getEvaluationType();
            String refname = "value" + ++count;
            block.declareVar(evaluationType, refname, forge.evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope)).staticMethod(ExprNumberSetList.class, METHOD_HANDLEEXPRNUMBERSETLISTADD, CodegenExpressionBuilder.ref(refname), CodegenExpressionBuilder.ref("parameters"));
        }
        block.staticMethod(ExprNumberSetList.class, METHOD_HANDLEEXPRNUMBERSETLISTEMPTY, CodegenExpressionBuilder.ref("parameters")).methodReturn(CodegenExpressionBuilder.newInstance(ListParameter.class, CodegenExpressionBuilder.ref("parameters")));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return this.isConstantResult() ? ExprForgeComplexityEnum.NONE : ExprForgeComplexityEnum.INTER;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    public static void handleExprNumberSetListEmpty(List<NumberSetParameter> parameters) {
        if (parameters.isEmpty()) {
            log.warn("Empty list of values in list parameter, using upper bounds");
            parameters.add(new IntParameter(Integer.MAX_VALUE));
        }
    }

    public static void handleExprNumberSetListAdd(Object value, List<NumberSetParameter> parameters) {
        if (value == null) {
            log.info("Null value returned for lower bounds value in list parameter, skipping parameter");
            return;
        }
        if (value instanceof FrequencyParameter || value instanceof RangeParameter) {
            parameters.add((NumberSetParameter)value);
            return;
        }
        int intValue = ((Number)value).intValue();
        parameters.add(new IntParameter(intValue));
    }
}

