/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.dot;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.dot.ExprDotEval;
import com.espertech.esper.epl.expression.dot.ExprDotEvalVisitor;
import com.espertech.esper.epl.expression.dot.ExprDotForge;
import com.espertech.esper.epl.expression.dot.ExprDotMethodForgeNoDuckEvalPlain;
import com.espertech.esper.epl.expression.dot.ExprDotMethodForgeNoDuckEvalUnderlying;
import com.espertech.esper.epl.expression.dot.ExprDotMethodForgeNoDuckEvalWrapArray;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import net.sf.cglib.reflect.FastMethod;

public class ExprDotMethodForgeNoDuck
implements ExprDotForge {
    private final String statementName;
    private final FastMethod method;
    private final ExprForge[] parameters;
    private final Type type;

    public ExprDotMethodForgeNoDuck(String statementName, FastMethod method, ExprForge[] parameters, Type type) {
        this.statementName = statementName;
        this.method = method;
        this.parameters = parameters;
        this.type = type;
    }

    @Override
    public EPType getTypeInfo() {
        if (this.type == Type.WRAPARRAY) {
            return EPTypeHelper.collectionOfSingleValue(this.method.getReturnType().getComponentType());
        }
        return EPTypeHelper.fromMethod(this.method.getJavaMethod());
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitMethod(this.method.getName());
    }

    @Override
    public ExprDotEval getDotEvaluator() {
        ExprEvaluator[] evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(this.parameters);
        if (this.type == Type.WRAPARRAY) {
            return new ExprDotMethodForgeNoDuckEvalWrapArray(this, evaluators);
        }
        if (this.type == Type.PLAIN) {
            return new ExprDotMethodForgeNoDuckEvalPlain(this, evaluators);
        }
        return new ExprDotMethodForgeNoDuckEvalUnderlying(this, evaluators);
    }

    @Override
    public CodegenExpression codegen(CodegenExpression inner, Class innerType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.type == Type.WRAPARRAY) {
            return ExprDotMethodForgeNoDuckEvalWrapArray.codegenWrapArray(this, inner, innerType, codegenMethodScope, exprSymbol, codegenClassScope);
        }
        if (this.type == Type.PLAIN) {
            return ExprDotMethodForgeNoDuckEvalPlain.codegenPlain(this, inner, innerType, codegenMethodScope, exprSymbol, codegenClassScope);
        }
        return ExprDotMethodForgeNoDuckEvalUnderlying.codegenUnderlying(this, inner, innerType, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    public String getStatementName() {
        return this.statementName;
    }

    public FastMethod getMethod() {
        return this.method;
    }

    public ExprForge[] getParameters() {
        return this.parameters;
    }

    public static enum Type {
        WRAPARRAY,
        UNDERLYING,
        PLAIN;

    }
}

