/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.funcs.ExprCastNode;
import com.espertech.esper.epl.expression.funcs.ExprCastNodeForgeConstEval;
import com.espertech.esper.epl.expression.funcs.ExprCastNodeForgeNonConstEval;

public class ExprCastNodeForge
implements ExprForge {
    private final ExprCastNode parent;
    private final ExprCastNode.CasterParserComputerForge casterParserComputerForge;
    private final Class targetType;
    private final boolean isConstant;
    private final Object constant;

    ExprCastNodeForge(ExprCastNode parent, ExprCastNode.CasterParserComputerForge casterParserComputerForge, Class targetType, boolean isConstant, Object constant) {
        this.parent = parent;
        this.casterParserComputerForge = casterParserComputerForge;
        this.targetType = targetType;
        this.isConstant = isConstant;
        this.constant = constant;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        if (this.isConstant) {
            return new ExprCastNodeForgeConstEval(this, this.constant);
        }
        return new ExprCastNodeForgeNonConstEval(this, this.parent.getChildNodes()[0].getForge().getExprEvaluator(), this.casterParserComputerForge.getEvaluatorComputer());
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.isConstant) {
            CodegenMember member = codegenClassScope.makeAddMember(this.targetType, this.constant);
            return CodegenExpressionBuilder.member(member.getMemberId());
        }
        return ExprCastNodeForgeNonConstEval.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return this.isConstant() ? ExprForgeComplexityEnum.NONE : ExprForgeComplexityEnum.INTER;
    }

    @Override
    public Class getEvaluationType() {
        return this.targetType;
    }

    @Override
    public ExprCastNode getForgeRenderable() {
        return this.parent;
    }

    public ExprCastNode.CasterParserComputerForge getCasterParserComputerForge() {
        return this.casterParserComputerForge;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public Object getConstant() {
        return this.constant;
    }
}

