/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.funcs.ExprTypeofNode;
import com.espertech.esper.epl.expression.funcs.ExprTypeofNodeForge;
import com.espertech.esper.event.EventPropertyGetterSPI;

public class ExprTypeofNodeForgeFragmentType
extends ExprTypeofNodeForge
implements ExprEvaluator {
    private final ExprTypeofNode parent;
    private final int streamId;
    private final EventPropertyGetterSPI getter;
    private final String fragmentType;

    public ExprTypeofNodeForgeFragmentType(ExprTypeofNode parent, int streamId, EventPropertyGetterSPI getter, String fragmentType) {
        this.parent = parent;
        this.streamId = streamId;
        this.getter = getter;
        this.fragmentType = fragmentType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean event = eventsPerStream[this.streamId];
        if (event == null) {
            return null;
        }
        Object fragment = this.getter.getFragment(event);
        if (fragment == null) {
            return null;
        }
        if (fragment instanceof EventBean) {
            EventBean bean = (EventBean)fragment;
            return bean.getEventType().getName();
        }
        if (fragment.getClass().isArray()) {
            String type = this.fragmentType + "[]";
            return type;
        }
        return null;
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(String.class, ExprTypeofNodeForgeFragmentType.class, codegenClassScope);
        CodegenExpressionRef refEPS = exprSymbol.getAddEPS(methodNode);
        methodNode.getBlock().declareVar(EventBean.class, "event", CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.streamId))).ifRefNullReturnNull("event").declareVar(Object.class, "fragment", this.getter.eventBeanFragmentCodegen(CodegenExpressionBuilder.ref("event"), methodNode, codegenClassScope)).ifRefNullReturnNull("fragment").ifInstanceOf("fragment", EventBean.class).blockReturn(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.cast(EventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("fragment"))).add("getEventType", new CodegenExpression[0]).add("getName", new CodegenExpression[0])).ifCondition(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.ref("fragment")).add("getClass", new CodegenExpression[0]).add("isArray", new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constant(this.fragmentType + "[]")).methodReturn(CodegenExpressionBuilder.constantNull());
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.SINGLE;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this.parent;
    }
}

