/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.methodagg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorWildcard;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeWildcard;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprWildcard;

public class ExprMethodAggUtil {
    public static ExprForge[] getDefaultForges(ExprNode[] childNodes, boolean join, EventType[] typesPerStream) throws ExprValidationException {
        if (childNodes.length == 0) {
            return ExprNodeUtilityCore.EMPTY_FORGE_ARRAY;
        }
        ExprForge[] forges = new ExprForge[childNodes.length];
        for (int i = 0; i < childNodes.length; ++i) {
            if (childNodes[i] instanceof ExprWildcard) {
                ExprMethodAggUtil.validateWildcard(typesPerStream, join);
                forges[i] = new ExprForgeWildcard(typesPerStream[0].getUnderlyingType());
                continue;
            }
            forges[i] = childNodes[i].getForge();
        }
        return forges;
    }

    public static ExprEvaluator getMultiNodeEvaluator(ExprNode[] childNodes, boolean join, EventType[] typesPerStream) throws ExprValidationException {
        final ExprEvaluator[] evaluators = new ExprEvaluator[childNodes.length];
        int count = 0;
        for (ExprNode node : childNodes) {
            evaluators[count] = node instanceof ExprWildcard ? ExprMethodAggUtil.getWildcardEvaluator(typesPerStream, join) : node.getForge().getExprEvaluator();
            ++count;
        }
        return new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                Object[] values = new Object[evaluators.length];
                for (int i = 0; i < evaluators.length; ++i) {
                    values[i] = evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                }
                return values;
            }
        };
    }

    private static ExprEvaluator getWildcardEvaluator(EventType[] typesPerStream, boolean isJoin) throws ExprValidationException {
        ExprMethodAggUtil.validateWildcard(typesPerStream, isJoin);
        return ExprEvaluatorWildcard.INSTANCE;
    }

    private static void validateWildcard(EventType[] typesPerStream, boolean isJoin) throws ExprValidationException {
        Class returnType;
        Class clazz = returnType = typesPerStream != null && typesPerStream.length > 0 ? typesPerStream[0].getUnderlyingType() : null;
        if (isJoin || returnType == null) {
            throw new ExprValidationException("Invalid use of wildcard (*) for stream selection in a join or an empty from-clause, please use the stream-alias syntax to select a specific stream instead");
        }
    }
}

