/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprArrayNode;
import com.espertech.esper.epl.expression.ops.ExprArrayNodeForgeEval;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.SimpleNumberCoercer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;

public class ExprArrayNodeForge
implements ExprForge,
ExprEnumerationForge {
    private final ExprArrayNode parent;
    private final Class arrayReturnType;
    private final boolean mustCoerce;
    private final SimpleNumberCoercer coercer;
    private final Object constantResult;

    public ExprArrayNodeForge(ExprArrayNode parent, Class arrayReturnType, Object[] constantResult) {
        this.parent = parent;
        this.arrayReturnType = arrayReturnType;
        this.constantResult = constantResult;
        this.mustCoerce = false;
        this.coercer = null;
    }

    public ExprArrayNodeForge(ExprArrayNode parent, Class arrayReturnType, boolean mustCoerce, SimpleNumberCoercer coercer, Object constantResult) {
        this.parent = parent;
        this.arrayReturnType = arrayReturnType;
        this.mustCoerce = mustCoerce;
        this.coercer = coercer;
        this.constantResult = constantResult;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        if (this.constantResult != null) {
            return new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return ExprArrayNodeForge.this.constantResult;
                }
            };
        }
        return new ExprArrayNodeForgeEval(this, ExprNodeUtilityCore.getEvaluatorsNoCompile(this.parent.getChildNodes()));
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.constantResult != null) {
            CodegenMember array = codegenClassScope.makeAddMember(this.getEvaluationType(), this.constantResult);
            return CodegenExpressionBuilder.member(array.getMemberId());
        }
        return ExprArrayNodeForgeEval.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return this.constantResult != null ? ExprForgeComplexityEnum.NONE : ExprForgeComplexityEnum.INTER;
    }

    @Override
    public CodegenExpression evaluateGetROCollectionScalarCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprArrayNodeForgeEval.codegenEvaluateGetROCollectionScalar(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Class getEvaluationType() {
        return Array.newInstance(this.arrayReturnType, 0).getClass();
    }

    @Override
    public ExprArrayNode getForgeRenderable() {
        return this.parent;
    }

    public Class getArrayReturnType() {
        return this.arrayReturnType;
    }

    public boolean isMustCoerce() {
        return this.mustCoerce;
    }

    public SimpleNumberCoercer getCoercer() {
        return this.coercer;
    }

    public Object getConstantResult() {
        return this.constantResult;
    }

    @Override
    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        if (this.constantResult != null) {
            final ArrayList<Object> constantResultList = new ArrayList<Object>();
            for (int i = 0; i < this.parent.getChildNodes().length; ++i) {
                constantResultList.add(Array.get(this.constantResult, i));
            }
            return new ExprEnumerationEval(){

                @Override
                public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return null;
                }

                @Override
                public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return constantResultList;
                }

                @Override
                public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return null;
                }
            };
        }
        return new ExprArrayNodeForgeEval(this, ExprNodeUtilityCore.getEvaluatorsNoCompile(this.parent.getChildNodes()));
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return null;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return this.parent.getComponentTypeCollection();
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return null;
    }

    @Override
    public CodegenExpression evaluateGetROCollectionEventsCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression evaluateGetEventBeanCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }
}

