/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.ops.ExprRegexpNodeForgeConstEval;
import com.espertech.esper.epl.expression.ops.ExprRegexpNodeForgeNonconst;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ExprRegexpNodeForgeNonconstEval
implements ExprEvaluator {
    private final ExprRegexpNodeForgeNonconst forge;
    private final ExprEvaluator lhsEval;
    private final ExprEvaluator patternEval;

    public ExprRegexpNodeForgeNonconstEval(ExprRegexpNodeForgeNonconst forge, ExprEvaluator lhsEval, ExprEvaluator patternEval) {
        this.forge = forge;
        this.lhsEval = lhsEval;
        this.patternEval = patternEval;
    }

    public static Pattern exprRegexNodeCompilePattern(String text) {
        try {
            return Pattern.compile(text);
        }
        catch (PatternSyntaxException ex) {
            throw new EPException("Error compiling regex pattern '" + text + "': " + ex.getMessage(), ex);
        }
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        String patternText = (String)this.patternEval.evaluate(eventsPerStream, isNewData, context);
        if (patternText == null) {
            return null;
        }
        Pattern pattern = ExprRegexpNodeForgeNonconstEval.exprRegexNodeCompilePattern(patternText);
        Object evalValue = this.lhsEval.evaluate(eventsPerStream, isNewData, context);
        if (evalValue == null) {
            return null;
        }
        if (this.forge.isNumericValue()) {
            evalValue = evalValue.toString();
        }
        boolean result = this.forge.getForgeRenderable().isNot() ^ pattern.matcher((CharSequence)evalValue).matches();
        return result;
    }

    public static CodegenMethodNode codegen(ExprRegexpNodeForgeNonconst forge, ExprNode lhs, ExprNode pattern, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, ExprRegexpNodeForgeNonconstEval.class, codegenClassScope);
        CodegenBlock blockMethod = methodNode.getBlock().declareVar(String.class, "patternText", pattern.getForge().evaluateCodegen(String.class, methodNode, exprSymbol, codegenClassScope)).ifRefNullReturnNull("patternText");
        blockMethod.declareVar(Pattern.class, "pattern", CodegenExpressionBuilder.staticMethod(ExprRegexpNodeForgeNonconstEval.class, "exprRegexNodeCompilePattern", CodegenExpressionBuilder.ref("patternText")));
        if (!forge.isNumericValue()) {
            blockMethod.declareVar(String.class, "value", lhs.getForge().evaluateCodegen(String.class, methodNode, exprSymbol, codegenClassScope)).ifRefNullReturnNull("value").methodReturn(ExprRegexpNodeForgeConstEval.getRegexpCode(forge, CodegenExpressionBuilder.ref("pattern"), CodegenExpressionBuilder.ref("value")));
        } else {
            blockMethod.declareVar(Object.class, "value", lhs.getForge().evaluateCodegen(Object.class, methodNode, exprSymbol, codegenClassScope)).ifRefNullReturnNull("value").methodReturn(ExprRegexpNodeForgeConstEval.getRegexpCode(forge, CodegenExpressionBuilder.ref("pattern"), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "toString", new CodegenExpression[0])));
        }
        return methodNode;
    }
}

