/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.subquery;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRow;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRowFilteredSelected;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRowFilteredUnselected;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRowFilteredUnselectedTable;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRowHavingSelected;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRowUnfilteredSelected;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRowUnfilteredSelectedGroupedNoHaving;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRowUnfilteredSelectedGroupedWHaving;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRowUnfilteredUnselected;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRowUnfilteredUnselectedTable;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExprSubselectRowNode
extends ExprSubselectNode {
    private static final long serialVersionUID = -7865711714805807559L;
    public static final SubselectEvalStrategyRow UNFILTERED_SELECTED = new SubselectEvalStrategyRowUnfilteredSelected();
    public static final SubselectEvalStrategyRow FILTERED_UNSELECTED = new SubselectEvalStrategyRowFilteredUnselected();
    public static final SubselectEvalStrategyRow FILTERED_SELECTED = new SubselectEvalStrategyRowFilteredSelected();
    public static final SubselectEvalStrategyRow HAVING_SELECTED = new SubselectEvalStrategyRowHavingSelected();
    public static final SubselectEvalStrategyRow UNFILTERED_SELECTED_GROUPED = new SubselectEvalStrategyRowUnfilteredSelectedGroupedNoHaving();
    protected transient SubselectMultirowType subselectMultirowType;
    private transient SubselectEvalStrategyRow evalStrategy;

    public ExprSubselectRowNode(StatementSpecRaw statementSpec) {
        super(statementSpec);
    }

    @Override
    public Class getEvaluationType() {
        if (this.selectClause == null) {
            return this.rawEventType.getUnderlyingType();
        }
        if (this.selectClause.length == 1) {
            return JavaClassHelper.getBoxedType(this.selectClause[0].getForge().getEvaluationType());
        }
        return Map.class;
    }

    @Override
    public void validateSubquery(ExprValidationContext validationContext) throws ExprValidationException {
        TableMetadata tableMetadata;
        this.evalStrategy = this.filterExpr == null ? (this.selectClause == null ? ((tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(this.rawEventType)) != null ? new SubselectEvalStrategyRowUnfilteredUnselectedTable(tableMetadata) : SubselectEvalStrategyRowUnfilteredUnselected.INSTANCE) : (this.getStatementSpecCompiled().getGroupByExpressions() != null && this.getStatementSpecCompiled().getGroupByExpressions().getGroupByNodes().length > 0 ? (this.havingExpr != null ? new SubselectEvalStrategyRowUnfilteredSelectedGroupedWHaving(this.havingExpr) : UNFILTERED_SELECTED_GROUPED) : (this.havingExpr != null ? HAVING_SELECTED : UNFILTERED_SELECTED))) : (this.selectClause == null ? ((tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(this.rawEventType)) != null ? new SubselectEvalStrategyRowFilteredUnselectedTable(tableMetadata) : FILTERED_UNSELECTED) : FILTERED_SELECTED);
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (matchingEvents == null || matchingEvents.size() == 0) {
            return null;
        }
        return this.evalStrategy.evaluate(eventsPerStream, isNewData, matchingEvents, exprEvaluatorContext, this);
    }

    @Override
    public Collection<EventBean> evaluateGetCollEvents(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext context) {
        if (matchingEvents == null) {
            return null;
        }
        if (matchingEvents.size() == 0) {
            return Collections.emptyList();
        }
        return this.evalStrategy.evaluateGetCollEvents(eventsPerStream, isNewData, matchingEvents, context, this);
    }

    @Override
    public Collection evaluateGetCollScalar(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext context) {
        if (matchingEvents == null) {
            return null;
        }
        if (matchingEvents.size() == 0) {
            return Collections.emptyList();
        }
        return this.evalStrategy.evaluateGetCollScalar(eventsPerStream, isNewData, matchingEvents, context, this);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (matchingEvents == null || matchingEvents.size() == 0) {
            return null;
        }
        return this.evalStrategy.evaluateGetEventBean(eventsPerStream, isNewData, matchingEvents, exprEvaluatorContext, this);
    }

    @Override
    public Object[] evaluateTypableSingle(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (matchingEvents == null || matchingEvents.size() == 0) {
            return null;
        }
        return this.evalStrategy.typableEvaluate(eventsPerStream, isNewData, matchingEvents, exprEvaluatorContext, this);
    }

    @Override
    public Object[][] evaluateTypableMulti(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (matchingEvents == null) {
            return null;
        }
        if (matchingEvents.size() == 0) {
            return CollectionUtil.OBJECTARRAYARRAY_EMPTY;
        }
        return this.evalStrategy.typableEvaluateMultirow(eventsPerStream, isNewData, matchingEvents, exprEvaluatorContext, this);
    }

    @Override
    public LinkedHashMap<String, Object> typableGetRowProperties() throws ExprValidationException {
        if (this.selectClause == null || this.selectClause.length < 2) {
            return null;
        }
        return this.getRowType();
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        if (this.selectClause == null) {
            return null;
        }
        if (this.getSubselectAggregationType() != ExprSubselectNode.SubqueryAggregationType.FULLY_AGGREGATED_NOPROPS) {
            return null;
        }
        return this.getAssignAnonymousType(eventAdapterService, statementId);
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        ExprIdentNode identNode;
        FragmentEventType fragment;
        if (this.selectClause == null) {
            return this.rawEventType;
        }
        if (this.selectClause.length == 1 && this.selectClause[0] instanceof ExprIdentNode && (fragment = this.rawEventType.getFragmentType((identNode = (ExprIdentNode)this.selectClause[0]).getResolvedPropertyName())) != null && !fragment.isIndexed()) {
            return fragment.getFragmentType();
        }
        if (this.selectClause.length == 1) {
            return null;
        }
        if (this.getSubselectAggregationType() == ExprSubselectNode.SubqueryAggregationType.FULLY_AGGREGATED_NOPROPS) {
            return null;
        }
        return this.getAssignAnonymousType(eventAdapterService, statementId);
    }

    private EventType getAssignAnonymousType(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        LinkedHashMap<String, Object> rowType = this.getRowType();
        EventType resultEventType = eventAdapterService.createAnonymousMapType(statementId + "_subquery_" + this.getSubselectNumber(), rowType, true);
        this.subselectMultirowType = new SubselectMultirowType(resultEventType, eventAdapterService);
        return resultEventType;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        if (this.selectClause == null) {
            return null;
        }
        if (this.selectClauseEvaluator.length > 1) {
            return null;
        }
        return this.selectClause[0].getForge().getEvaluationType();
    }

    @Override
    public boolean isAllowMultiColumnSelect() {
        return true;
    }

    private LinkedHashMap<String, Object> getRowType() throws ExprValidationException {
        HashSet<String> uniqueNames = new HashSet<String>();
        LinkedHashMap<String, Object> type = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.selectClause.length; ++i) {
            String assignedName = this.selectAsNames[i];
            if (assignedName == null) {
                assignedName = ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(this.selectClause[i]);
            }
            if (!uniqueNames.add(assignedName)) {
                throw new ExprValidationException("Column " + i + " in subquery does not have a unique column name assigned");
            }
            type.put(assignedName, this.selectClause[i].getForge().getEvaluationType());
        }
        return type;
    }

    public String getMultirowMessage() {
        return "Subselect of statement '" + this.statementName + "' returned more then one row in subselect " + this.subselectNumber + " '" + ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(this) + "', returning null result";
    }

    protected Map<String, Object> evaluateRow(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.selectClauseEvaluator.length; ++i) {
            Object resultEntry = this.selectClauseEvaluator[i].evaluate(eventsPerStream, isNewData, context);
            map.put(this.selectAsNames[i], resultEntry);
        }
        return map;
    }

    protected static class SubselectMultirowType {
        private final EventType eventType;
        private final EventAdapterService eventAdapterService;

        private SubselectMultirowType(EventType eventType, EventAdapterService eventAdapterService) {
            this.eventType = eventType;
            this.eventAdapterService = eventAdapterService;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public EventAdapterService getEventAdapterService() {
            return this.eventAdapterService;
        }
    }
}

