/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.table;

import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.table.ExprTableAccessEvalStrategy;
import com.espertech.esper.epl.expression.table.ExprTableNodeUtil;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumn;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import java.io.StringWriter;

public abstract class ExprTableAccessNode
extends ExprNodeBase
implements ExprForge {
    private static final long serialVersionUID = -2048267912299812034L;
    protected final String tableName;
    protected transient ExprTableAccessEvalStrategy strategy;
    protected transient ExprEvaluator[] groupKeyEvaluators;

    protected abstract void validateBindingInternal(ExprValidationContext var1, TableMetadata var2) throws ExprValidationException;

    protected abstract boolean equalsNodeInternal(ExprTableAccessNode var1);

    protected ExprTableAccessNode(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ExprEvaluator[] getGroupKeyEvaluators() {
        return this.groupKeyEvaluators;
    }

    public void setStrategy(ExprTableAccessEvalStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public final ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (validationContext.getTableService() == null || !validationContext.isAllowBindingConsumption()) {
            throw new ExprValidationException("Invalid use of table access expression, expression '" + this.tableName + "' is not allowed here");
        }
        TableMetadata metadata = validationContext.getTableService().getTableMetadata(this.tableName);
        if (metadata == null) {
            throw new ExprValidationException("A table '" + this.tableName + "' could not be found");
        }
        if (metadata.getContextName() != null && validationContext.getContextDescriptor() != null && !metadata.getContextName().equals(validationContext.getContextDescriptor().getContextName())) {
            throw new ExprValidationException("Table by name '" + this.tableName + "' has been declared for context '" + metadata.getContextName() + "' and can only be used within the same context");
        }
        this.validateBindingInternal(validationContext, metadata);
        return null;
    }

    protected void validateGroupKeys(TableMetadata metadata, ExprValidationContext validationContext) throws ExprValidationException {
        this.groupKeyEvaluators = this.getChildNodes().length > 0 ? ExprNodeUtilityRich.getEvaluatorsMayCompile(this.getChildNodes(), validationContext.getEngineImportService(), ExprTableAccessNode.class, validationContext.getStreamTypeService().isOnDemandStreams(), validationContext.getStatementName()) : new ExprEvaluator[0];
        Class[] typesReturned = ExprNodeUtilityCore.getExprResultTypes(this.getChildNodes());
        ExprTableNodeUtil.validateExpressions(this.tableName, typesReturned, "key", this.getChildNodes(), metadata.getKeyTypes(), "key");
    }

    @Override
    public final ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    protected void toPrecedenceFreeEPLInternal(StringWriter writer, String subprop) {
        this.toPrecedenceFreeEPLInternal(writer);
        writer.append(".");
        writer.append(subprop);
    }

    protected void toPrecedenceFreeEPLInternal(StringWriter writer) {
        writer.append(this.tableName);
        if (this.getChildNodes().length > 0) {
            writer.append("[");
            String delimiter = "";
            for (ExprNode expr : this.getChildNodes()) {
                writer.append(delimiter);
                expr.toEPL(writer, ExprPrecedenceEnum.MINIMUM);
                delimiter = ",";
            }
            writer.append("]");
        }
    }

    protected TableMetadataColumn validateSubpropertyGetCol(TableMetadata tableMetadata, String subpropName) throws ExprValidationException {
        TableMetadataColumn column = tableMetadata.getTableColumns().get(subpropName);
        if (column == null) {
            throw new ExprValidationException("A column '" + subpropName + "' could not be found for table '" + this.tableName + "'");
        }
        return column;
    }

    @Override
    public boolean equalsNode(ExprNode o, boolean ignoreStreamPrefix) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExprTableAccessNode that = (ExprTableAccessNode)o;
        if (!this.tableName.equals(that.tableName)) {
            return false;
        }
        return this.equalsNodeInternal(that);
    }

    public int hashCode() {
        return this.tableName != null ? this.tableName.hashCode() : 0;
    }
}

