/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.index.quadtree;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotNodeImpl;
import com.espertech.esper.epl.index.quadtree.EngineImportApplicationDotMethodBase;
import com.espertech.esper.epl.index.quadtree.EngineImportApplicationDotMethodRectangeIntersectsRectangle;
import com.espertech.esper.epl.util.EPLExpressionParamType;
import com.espertech.esper.epl.util.EPLValidationUtil;
import com.espertech.esper.spatial.quadtree.core.BoundingBox;

public class EngineImportApplicationDotMethodPointInsideRectange
extends EngineImportApplicationDotMethodBase {
    protected static final String LOOKUP_OPERATION_NAME = "point.inside(rectangle)";
    public static final String INDEXTYPE_NAME = "pointregionquadtree";

    public EngineImportApplicationDotMethodPointInsideRectange(ExprDotNodeImpl parent, String lhsName, ExprNode[] lhs, String dotMethodName, String rhsName, ExprNode[] rhs, ExprNode[] indexNamedParameter) {
        super(parent, lhsName, lhs, dotMethodName, rhsName, rhs, indexNamedParameter);
    }

    @Override
    protected ExprForge validateAll(String lhsName, ExprNode[] lhs, String rhsName, ExprNode[] rhs, ExprValidationContext validationContext) throws ExprValidationException {
        EPLValidationUtil.validateParameterNumber(lhsName, "left-hand-side", false, 2, lhs.length);
        EPLValidationUtil.validateParametersTypePredefined(lhs, lhsName, "left-hand-side", EPLExpressionParamType.NUMERIC);
        EPLValidationUtil.validateParameterNumber(rhsName, "right-hand-side", true, 4, rhs.length);
        EPLValidationUtil.validateParametersTypePredefined(rhs, rhsName, "right-hand-side", EPLExpressionParamType.NUMERIC);
        ExprForge pxEval = lhs[0].getForge();
        ExprForge pyEval = lhs[1].getForge();
        ExprForge xEval = rhs[0].getForge();
        ExprForge yEval = rhs[1].getForge();
        ExprForge widthEval = rhs[2].getForge();
        ExprForge heightEval = rhs[3].getForge();
        return new PointIntersectsRectangleForge(this.parent, pxEval, pyEval, xEval, yEval, widthEval, heightEval);
    }

    @Override
    protected String operationName() {
        return LOOKUP_OPERATION_NAME;
    }

    @Override
    protected String indexTypeName() {
        return INDEXTYPE_NAME;
    }

    public static final class PointIntersectsRectangleEvaluator
    implements ExprEvaluator {
        private final ExprEvaluator pxEval;
        private final ExprEvaluator pyEval;
        private final ExprEvaluator xEval;
        private final ExprEvaluator yEval;
        private final ExprEvaluator widthEval;
        private final ExprEvaluator heightEval;

        PointIntersectsRectangleEvaluator(ExprEvaluator pxEval, ExprEvaluator pyEval, ExprEvaluator xEval, ExprEvaluator yEval, ExprEvaluator widthEval, ExprEvaluator heightEval) {
            this.pxEval = pxEval;
            this.pyEval = pyEval;
            this.xEval = xEval;
            this.yEval = yEval;
            this.widthEval = widthEval;
            this.heightEval = heightEval;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Number px = (Number)this.pxEval.evaluate(eventsPerStream, isNewData, context);
            if (px == null) {
                return null;
            }
            Number py = (Number)this.pyEval.evaluate(eventsPerStream, isNewData, context);
            if (py == null) {
                return null;
            }
            Number x = (Number)this.xEval.evaluate(eventsPerStream, isNewData, context);
            if (x == null) {
                return null;
            }
            Number y = (Number)this.yEval.evaluate(eventsPerStream, isNewData, context);
            if (y == null) {
                return null;
            }
            Number width = (Number)this.widthEval.evaluate(eventsPerStream, isNewData, context);
            if (width == null) {
                return null;
            }
            Number height = (Number)this.heightEval.evaluate(eventsPerStream, isNewData, context);
            if (height == null) {
                return null;
            }
            return BoundingBox.containsPoint(x.doubleValue(), y.doubleValue(), width.doubleValue(), height.doubleValue(), px.doubleValue(), py.doubleValue());
        }

        public static CodegenExpression codegen(PointIntersectsRectangleForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, EngineImportApplicationDotMethodRectangeIntersectsRectangle.RectangleIntersectsRectangleEvaluator.class, codegenClassScope);
            CodegenBlock block = methodNode.getBlock();
            CodegenLegoCast.asDoubleNullReturnNull(block, "px", forge.pxEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "py", forge.pyEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "x", forge.xEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "y", forge.yEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "width", forge.widthEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "height", forge.heightEval, methodNode, exprSymbol, codegenClassScope);
            block.methodReturn(CodegenExpressionBuilder.staticMethod(BoundingBox.class, "containsPoint", CodegenExpressionBuilder.ref("x"), CodegenExpressionBuilder.ref("y"), CodegenExpressionBuilder.ref("width"), CodegenExpressionBuilder.ref("height"), CodegenExpressionBuilder.ref("px"), CodegenExpressionBuilder.ref("py")));
            return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
        }
    }

    public static final class PointIntersectsRectangleForge
    implements ExprForge {
        private final ExprDotNodeImpl parent;
        protected final ExprForge pxEval;
        protected final ExprForge pyEval;
        protected final ExprForge xEval;
        protected final ExprForge yEval;
        protected final ExprForge widthEval;
        protected final ExprForge heightEval;

        public PointIntersectsRectangleForge(ExprDotNodeImpl parent, ExprForge pxEval, ExprForge pyEval, ExprForge xEval, ExprForge yEval, ExprForge widthEval, ExprForge heightEval) {
            this.parent = parent;
            this.pxEval = pxEval;
            this.pyEval = pyEval;
            this.xEval = xEval;
            this.yEval = yEval;
            this.widthEval = widthEval;
            this.heightEval = heightEval;
        }

        @Override
        public ExprEvaluator getExprEvaluator() {
            return new PointIntersectsRectangleEvaluator(this.pxEval.getExprEvaluator(), this.pyEval.getExprEvaluator(), this.xEval.getExprEvaluator(), this.yEval.getExprEvaluator(), this.widthEval.getExprEvaluator(), this.heightEval.getExprEvaluator());
        }

        @Override
        public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return PointIntersectsRectangleEvaluator.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
        }

        @Override
        public ExprForgeComplexityEnum getComplexity() {
            return ExprForgeComplexityEnum.INTER;
        }

        @Override
        public Class getEvaluationType() {
            return Boolean.class;
        }

        @Override
        public ExprNodeRenderable getForgeRenderable() {
            return this.parent;
        }
    }
}

