/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.plan.InKeywordTableLookupUtil;
import com.espertech.esper.epl.join.table.EventTable;
import java.util.Iterator;
import java.util.Set;

public class HistoricalIndexLookupStrategyInKeywordMulti
implements HistoricalIndexLookupStrategy {
    private final EventBean[] eventsPerStream;
    private final ExprEvaluator evaluator;
    private final int lookupStream;

    public HistoricalIndexLookupStrategyInKeywordMulti(int lookupStream, ExprNode expression) {
        this.eventsPerStream = new EventBean[lookupStream + 1];
        this.evaluator = expression.getForge().getExprEvaluator();
        this.lookupStream = lookupStream;
    }

    @Override
    public Iterator<EventBean> lookup(EventBean lookupEvent, EventTable[] indexTable, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventsPerStream[this.lookupStream] = lookupEvent;
        Set<EventBean> result = InKeywordTableLookupUtil.multiIndexLookup(this.evaluator, this.eventsPerStream, exprEvaluatorContext, indexTable);
        if (result == null) {
            return null;
        }
        return result.iterator();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName();
    }
}

