/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import java.util.Set;

public class IndexedTableLookupStrategyExpr
implements JoinExecTableLookupStrategy {
    private final PropertyIndexedEventTable index;
    private final int streamNum;
    private final EventBean[] eventsPerStream;
    private final ExprEvaluator[] evaluators;
    private final LookupStrategyDesc lookupStrategyDesc;

    public IndexedTableLookupStrategyExpr(ExprEvaluator[] evaluators, int streamNum, PropertyIndexedEventTable index, LookupStrategyDesc lookupStrategyDesc) {
        if (index == null) {
            throw new IllegalArgumentException("Unexpected null index received");
        }
        this.index = index;
        this.streamNum = streamNum;
        this.eventsPerStream = new EventBean[streamNum + 1];
        this.evaluators = evaluators;
        this.lookupStrategyDesc = lookupStrategyDesc;
    }

    public PropertyIndexedEventTable getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] keys = new Object[this.evaluators.length];
        this.eventsPerStream[this.streamNum] = theEvent;
        for (int i = 0; i < this.evaluators.length; ++i) {
            keys[i] = this.evaluators[i].evaluate(this.eventsPerStream, true, exprEvaluatorContext);
        }
        return this.index.lookup(keys);
    }

    public String toString() {
        return "IndexedTableLookupStrategyExpr expressions index=(" + this.index + ')';
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return this.lookupStrategyDesc;
    }
}

