/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.assemble.BaseAssemblyNode;
import com.espertech.esper.epl.join.assemble.BaseAssemblyNodeFactory;
import com.espertech.esper.epl.join.assemble.ResultAssembler;
import com.espertech.esper.epl.join.exec.base.ExecNode;
import com.espertech.esper.epl.join.exec.base.LookupInstructionExec;
import com.espertech.esper.epl.join.rep.Node;
import com.espertech.esper.epl.join.rep.RepositoryImpl;
import com.espertech.esper.util.IndentWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class LookupInstructionExecNode
extends ExecNode {
    private final int rootStream;
    private final String rootStreamName;
    private final int numStreams;
    private final boolean[] requiredPerStream;
    private final LookupInstructionExec[] lookupInstructions;
    private final BaseAssemblyNode[] assemblyInstructions;
    private final MyResultAssembler myResultAssembler;
    private int requireResultsInstruction;

    public LookupInstructionExecNode(int rootStream, String rootStreamName, int numStreams, LookupInstructionExec[] lookupInstructions, boolean[] requiredPerStream, List<BaseAssemblyNodeFactory> assemblyInstructionFactories) {
        int n;
        int i;
        this.rootStream = rootStream;
        this.rootStreamName = rootStreamName;
        this.numStreams = numStreams;
        this.lookupInstructions = lookupInstructions;
        this.requiredPerStream = requiredPerStream;
        IdentityHashMap<BaseAssemblyNodeFactory, BaseAssemblyNode> nodes = new IdentityHashMap<BaseAssemblyNodeFactory, BaseAssemblyNode>();
        for (BaseAssemblyNodeFactory baseAssemblyNodeFactory : assemblyInstructionFactories) {
            BaseAssemblyNode node = baseAssemblyNodeFactory.makeAssemblerUnassociated();
            nodes.put(baseAssemblyNodeFactory, node);
        }
        for (Map.Entry entry : nodes.entrySet()) {
            BaseAssemblyNodeFactory parentFactory = ((BaseAssemblyNodeFactory)entry.getKey()).getParentNode();
            if (parentFactory != null) {
                BaseAssemblyNode parent = (BaseAssemblyNode)nodes.get(parentFactory);
                ((BaseAssemblyNode)entry.getValue()).setParentAssembler(parent);
            }
            for (BaseAssemblyNodeFactory childNodeFactory : ((BaseAssemblyNodeFactory)entry.getKey()).getChildNodes()) {
                BaseAssemblyNode child = (BaseAssemblyNode)nodes.get(childNodeFactory);
                ((BaseAssemblyNode)entry.getValue()).addChild(child);
            }
        }
        this.assemblyInstructions = new BaseAssemblyNode[assemblyInstructionFactories.size()];
        for (i = 0; i < assemblyInstructionFactories.size(); ++i) {
            this.assemblyInstructions[i] = (BaseAssemblyNode)nodes.get(assemblyInstructionFactories.get(i));
        }
        this.myResultAssembler = new MyResultAssembler(rootStream);
        this.assemblyInstructions[this.assemblyInstructions.length - 1].setParentAssembler(this.myResultAssembler);
        this.requireResultsInstruction = 1;
        for (i = 1; i < lookupInstructions.length && requiredPerStream[n = lookupInstructions[i].getFromStream()]; ++i) {
            this.requireResultsInstruction = i + 1;
        }
    }

    @Override
    public void process(EventBean lookupEvent, EventBean[] prefillPath, Collection<EventBean[]> resultFinalRows, ExprEvaluatorContext exprEvaluatorContext) {
        BaseAssemblyNode assemblyNode;
        int i;
        List<Node>[] results;
        LookupInstructionExec currentInstruction;
        int i2;
        RepositoryImpl repository = new RepositoryImpl(this.rootStream, lookupEvent, this.numStreams);
        boolean processOptional = true;
        for (i2 = 0; i2 < this.requireResultsInstruction; ++i2) {
            currentInstruction = this.lookupInstructions[i2];
            boolean hasResults = currentInstruction.process(repository, exprEvaluatorContext);
            if (hasResults) continue;
            if (currentInstruction.hasRequiredStream()) {
                return;
            }
            if (i2 != 0) continue;
            processOptional = false;
        }
        if (processOptional) {
            for (i2 = this.requireResultsInstruction; i2 < this.lookupInstructions.length; ++i2) {
                currentInstruction = this.lookupInstructions[i2];
                currentInstruction.process(repository, exprEvaluatorContext);
            }
        }
        if ((results = repository.getNodesPerStream()) == null) {
            BaseAssemblyNode lastAssemblyNode = this.assemblyInstructions[this.assemblyInstructions.length - 1];
            lastAssemblyNode.init(null);
            lastAssemblyNode.process(null, resultFinalRows, lookupEvent);
            return;
        }
        for (i = 0; i < this.assemblyInstructions.length; ++i) {
            assemblyNode = this.assemblyInstructions[i];
            assemblyNode.init(results);
        }
        for (i = 0; i < this.assemblyInstructions.length; ++i) {
            assemblyNode = this.assemblyInstructions[i];
            assemblyNode.process(results, resultFinalRows, lookupEvent);
        }
    }

    @Override
    public void print(IndentWriter writer) {
        int i;
        writer.println("LookupInstructionExecNode rootStream=" + this.rootStream + " name=" + this.rootStreamName + " requiredPerStream=" + Arrays.toString(this.requiredPerStream));
        writer.incrIndent();
        for (i = 0; i < this.lookupInstructions.length; ++i) {
            writer.println("lookup inst node " + i);
            writer.incrIndent();
            this.lookupInstructions[i].print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
        writer.incrIndent();
        for (i = 0; i < this.assemblyInstructions.length; ++i) {
            writer.println("assembly inst node " + i);
            writer.incrIndent();
            this.assemblyInstructions[i].print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
    }

    public static class MyResultAssembler
    implements ResultAssembler {
        private final int rootStream;

        public MyResultAssembler(int rootStream) {
            this.rootStream = rootStream;
        }

        @Override
        public void result(EventBean[] row, int fromStreamNum, EventBean myEvent, Node myNode, Collection<EventBean[]> resultFinalRows, EventBean resultRootEvent) {
            row[this.rootStream] = resultRootEvent;
            resultFinalRows.add(row);
        }
    }
}

