/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.table.EventTableAsSet;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PropertyIndexedEventTableUnique
extends PropertyIndexedEventTable
implements EventTableAsSet {
    protected final Map<MultiKeyUntyped, EventBean> propertyIndex;
    private final boolean canClear;

    public PropertyIndexedEventTableUnique(EventPropertyGetter[] propertyGetters, EventTableOrganization organization) {
        super(propertyGetters, organization);
        this.propertyIndex = new HashMap<MultiKeyUntyped, EventBean>();
        this.canClear = true;
    }

    public PropertyIndexedEventTableUnique(EventPropertyGetter[] propertyGetters, EventTableOrganization organization, Map<MultiKeyUntyped, EventBean> propertyIndex) {
        super(propertyGetters, organization);
        this.propertyIndex = propertyIndex;
        this.canClear = false;
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext exprEvaluatorContext) {
        if (oldData != null) {
            for (EventBean theEvent : oldData) {
                this.remove(theEvent, exprEvaluatorContext);
            }
        }
        if (newData != null) {
            for (EventBean theEvent : newData) {
                this.add(theEvent, exprEvaluatorContext);
            }
        }
    }

    @Override
    public Set<EventBean> lookup(Object[] keys) {
        MultiKeyUntyped key = new MultiKeyUntyped(keys);
        EventBean event = this.propertyIndex.get(key);
        if (event != null) {
            return Collections.singleton(event);
        }
        return null;
    }

    @Override
    public void add(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        MultiKeyUntyped key = this.getMultiKey(theEvent);
        EventBean existing = this.propertyIndex.put(key, theEvent);
        if (existing != null && !existing.equals(theEvent)) {
            throw PropertyIndexedEventTableUnique.handleUniqueIndexViolation(this.organization.getIndexName(), key);
        }
    }

    public static EPException handleUniqueIndexViolation(String indexName, Object key) {
        String indexNameDisplay = indexName == null ? "" : " '" + indexName + "'";
        throw new EPException("Unique index violation, index" + indexNameDisplay + " is a unique index and key '" + key + "' already exists");
    }

    @Override
    public void remove(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        MultiKeyUntyped key = this.getMultiKey(theEvent);
        this.propertyIndex.remove(key);
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.propertyIndex.values().iterator();
    }

    @Override
    public void clear() {
        if (this.canClear) {
            this.propertyIndex.clear();
        }
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public Integer getNumberOfEvents() {
        return this.propertyIndex.size();
    }

    @Override
    public int getNumKeys() {
        return this.propertyIndex.size();
    }

    @Override
    public Object getIndex() {
        return this.propertyIndex;
    }

    @Override
    public Set<EventBean> allValues() {
        if (this.propertyIndex.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<EventBean>(this.propertyIndex.values());
    }

    @Override
    public Class getProviderClass() {
        return PropertyIndexedEventTableUnique.class;
    }
}

