/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import java.io.StringWriter;

public class AdvancedIndexDesc {
    private final String indexTypeName;
    private final ExprNode[] indexedExpressions;

    public AdvancedIndexDesc(String indexTypeName, ExprNode[] indexedExpressions) {
        this.indexTypeName = indexTypeName;
        this.indexedExpressions = indexedExpressions;
    }

    public String getIndexTypeName() {
        return this.indexTypeName;
    }

    public ExprNode[] getIndexedExpressions() {
        return this.indexedExpressions;
    }

    public boolean equalsAdvancedIndex(AdvancedIndexDesc that) {
        return this.indexTypeName.equals(that.indexTypeName) && ExprNodeUtilityCore.deepEquals(this.indexedExpressions, that.indexedExpressions, true);
    }

    public String toQueryPlan() {
        if (this.indexedExpressions.length == 0) {
            return this.indexTypeName;
        }
        StringWriter writer = new StringWriter();
        writer.append(this.indexTypeName);
        writer.append("(");
        ExprNodeUtilityCore.toExpressionStringMinPrecedenceAsList(this.indexedExpressions, writer);
        writer.append(")");
        return writer.toString();
    }
}

