/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.metric;

import com.espertech.esper.client.ConfigurationMetricsReporting;
import com.espertech.esper.client.metric.StatementMetric;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.metric.StatementMetricArray;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.type.StringPatternSet;
import com.espertech.esper.type.StringPatternSetUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatementMetricRepository {
    private final ConfigurationMetricsReporting specification;
    private final StatementMetricArray[] groupMetrics;
    private final Map<String, Integer> statementGroups;

    public StatementMetricRepository(String engineURI, ConfigurationMetricsReporting specification) {
        this.specification = specification;
        int numGroups = specification.getStatementGroups().size() + 1;
        this.groupMetrics = new StatementMetricArray[numGroups];
        this.groupMetrics[0] = new StatementMetricArray(engineURI, "group-default", 100, false);
        int countGroups = 1;
        for (Map.Entry<String, ConfigurationMetricsReporting.StmtGroupMetrics> entry : specification.getStatementGroups().entrySet()) {
            ConfigurationMetricsReporting.StmtGroupMetrics config = entry.getValue();
            int initialNumStmts = config.getNumStatements();
            if (initialNumStmts < 10) {
                initialNumStmts = 10;
            }
            this.groupMetrics[countGroups] = new StatementMetricArray(engineURI, "group-" + countGroups, initialNumStmts, config.isReportInactive());
            ++countGroups;
        }
        this.statementGroups = new HashMap<String, Integer>();
    }

    public StatementMetricHandle addStatement(String stmtName) {
        int countGroups = 1;
        int groupNumber = -1;
        for (Map.Entry<String, ConfigurationMetricsReporting.StmtGroupMetrics> entry : this.specification.getStatementGroups().entrySet()) {
            List<Pair<StringPatternSet, Boolean>> patterns = entry.getValue().getPatterns();
            boolean result = StringPatternSetUtil.evaluate(entry.getValue().isDefaultInclude(), patterns, stmtName);
            if (result) {
                groupNumber = countGroups;
                break;
            }
            ++countGroups;
        }
        if (groupNumber == -1) {
            groupNumber = 0;
        }
        int index = this.groupMetrics[groupNumber].addStatementGetIndex(stmtName);
        this.statementGroups.put(stmtName, groupNumber);
        return new StatementMetricHandle(groupNumber, index);
    }

    public void removeStatement(String stmtName) {
        Integer group = this.statementGroups.remove(stmtName);
        if (group != null) {
            this.groupMetrics[group].removeStatement(stmtName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accountTimes(StatementMetricHandle handle, long cpu, long wall, int numInput) {
        StatementMetricArray array = this.groupMetrics[handle.getGroupNum()];
        array.getRwLock().acquireReadLock();
        try {
            StatementMetric metric = array.getAddMetric(handle.getIndex());
            metric.addCPUTime(cpu);
            metric.addWallTime(wall);
            metric.addNumInput(numInput);
        }
        finally {
            array.getRwLock().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accountOutput(StatementMetricHandle handle, int numIStream, int numRStream) {
        StatementMetricArray array = this.groupMetrics[handle.getGroupNum()];
        array.getRwLock().acquireReadLock();
        try {
            StatementMetric metric = array.getAddMetric(handle.getIndex());
            metric.addNumOutputIStream(numIStream);
            metric.addNumOutputRStream(numRStream);
        }
        finally {
            array.getRwLock().releaseReadLock();
        }
    }

    public StatementMetric[] reportGroup(int group) {
        return this.groupMetrics[group].flushMetrics();
    }
}

