/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTExprHelper;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.spec.CreateIndexDesc;
import com.espertech.esper.epl.spec.CreateIndexItem;
import com.espertech.esper.epl.spec.CreateIndexType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.tree.Tree;

public class ASTIndexHelper {
    public static CreateIndexDesc walk(EsperEPL2GrammarParser.CreateIndexExprContext ctx, Map<Tree, ExprNode> astExprNodeMap) {
        String indexName = ctx.n.getText();
        String windowName = ctx.w.getText();
        boolean unique = false;
        if (ctx.u != null) {
            String ident = ctx.u.getText();
            if (ident.toLowerCase(Locale.ENGLISH).trim().equals("unique")) {
                unique = true;
            } else {
                throw ASTWalkException.from("Invalid keyword '" + ident + "' in create-index encountered, expected 'unique'");
            }
        }
        ArrayList<CreateIndexItem> columns = new ArrayList<CreateIndexItem>();
        List<EsperEPL2GrammarParser.CreateIndexColumnContext> cols = ctx.createIndexColumnList().createIndexColumn();
        for (EsperEPL2GrammarParser.CreateIndexColumnContext col : cols) {
            CreateIndexItem item = ASTIndexHelper.walk(col, astExprNodeMap);
            columns.add(item);
        }
        return new CreateIndexDesc(unique, indexName, windowName, columns);
    }

    private static CreateIndexItem walk(EsperEPL2GrammarParser.CreateIndexColumnContext col, Map<Tree, ExprNode> astExprNodeMap) {
        List<ExprNode> expressions = Collections.emptyList();
        if (col.i != null) {
            expressions = ASTExprHelper.exprCollectSubNodes((Tree)col.i, 0, astExprNodeMap);
        } else if (col.expression() != null) {
            expressions = ASTExprHelper.exprCollectSubNodes((Tree)col.expression(), 0, astExprNodeMap);
        }
        String type = CreateIndexType.HASH.getNameLower();
        if (col.t != null) {
            type = col.t.getText();
        }
        List<ExprNode> parameters = Collections.emptyList();
        if (col.p != null) {
            parameters = ASTExprHelper.exprCollectSubNodes((Tree)col.p, 0, astExprNodeMap);
        }
        return new CreateIndexItem(expressions, type, parameters);
    }
}

