/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.property;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.select.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.property.PropertyEvaluatorAccumulative;
import com.espertech.esper.filterspec.PropertyEvaluator;
import java.util.ArrayDeque;

public class PropertyEvaluatorSelect
implements PropertyEvaluator {
    private final EventType resultEventType;
    private final SelectExprProcessor selectExprProcessor;
    private final PropertyEvaluatorAccumulative accumulative;

    public PropertyEvaluatorSelect(EventType resultEventType, SelectExprProcessor selectExprProcessor, PropertyEvaluatorAccumulative accumulative) {
        this.resultEventType = resultEventType;
        this.selectExprProcessor = selectExprProcessor;
        this.accumulative = accumulative;
    }

    @Override
    public EventBean[] getProperty(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayDeque<EventBean[]> rows = this.accumulative.getAccumulative(theEvent, exprEvaluatorContext);
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        ArrayDeque<EventBean> result = new ArrayDeque<EventBean>();
        for (EventBean[] row : rows) {
            EventBean bean = this.selectExprProcessor.process(row, true, false, exprEvaluatorContext);
            result.add(bean);
        }
        return result.toArray(new EventBean[result.size()]);
    }

    @Override
    public EventType getFragmentEventType() {
        return this.resultEventType;
    }

    @Override
    public boolean compareTo(PropertyEvaluator otherFilterPropertyEval) {
        return false;
    }
}

