/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.property;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.property.ContainedEventEval;
import com.espertech.esper.filterspec.PropertyEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEvaluatorSimple
implements PropertyEvaluator {
    private static final Logger log = LoggerFactory.getLogger(PropertyEvaluatorSimple.class);
    private final ContainedEventEval containedEventEval;
    private final FragmentEventType fragmentEventType;
    private final ExprEvaluator filter;
    private final String expressionText;

    public PropertyEvaluatorSimple(ContainedEventEval containedEventEval, FragmentEventType fragmentEventType, ExprEvaluator filter, String expressionText) {
        this.fragmentEventType = fragmentEventType;
        this.containedEventEval = containedEventEval;
        this.filter = filter;
        this.expressionText = expressionText;
    }

    @Override
    public EventBean[] getProperty(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            Object result = this.containedEventEval.getFragment(theEvent, new EventBean[]{theEvent}, exprEvaluatorContext);
            EventBean[] rows = this.fragmentEventType.isIndexed() ? (EventBean[])result : new EventBean[]{(EventBean)result};
            if (this.filter == null) {
                return rows;
            }
            return ExprNodeUtilityCore.applyFilterExpression(this.filter, theEvent, (EventBean[])result, exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            log.error("Unexpected error evaluating property expression for event of type '" + theEvent.getEventType().getName() + "' and property '" + this.expressionText + "': " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public EventType getFragmentEventType() {
        return this.fragmentEventType.getFragmentType();
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    public ExprEvaluator getFilter() {
        return this.filter;
    }

    @Override
    public boolean compareTo(PropertyEvaluator otherEval) {
        if (!(otherEval instanceof PropertyEvaluatorSimple)) {
            return false;
        }
        PropertyEvaluatorSimple other = (PropertyEvaluatorSimple)otherEval;
        if (!other.getExpressionText().equals(this.getExpressionText())) {
            return false;
        }
        return other.getFilter() == null && this.getFilter() == null;
    }
}

