/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.script;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.script.ExprNodeScript;
import com.espertech.esper.epl.script.ExprNodeScriptEvalBase;
import com.espertech.esper.epl.script.ExprNodeScriptEvaluator;
import com.espertech.esper.epl.script.mvel.MVELInvoker;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNodeScriptEvalMVEL
extends ExprNodeScriptEvalBase
implements ExprNodeScriptEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExprNodeScriptEvalMVEL.class);
    private final Object executable;
    private volatile ExprEvaluator[] evaluators;

    public ExprNodeScriptEvalMVEL(ExprNodeScript parent, String statementName, String[] names, ExprForge[] parameters, Class returnType, EventType eventTypeCollection, Object executable) {
        super(parent, statementName, names, parameters, returnType, eventTypeCollection);
        this.executable = executable;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (this.evaluators == null) {
            this.evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(this.parameters);
        }
        Map<String, Object> paramsList = ExprNodeScriptEvalMVEL.getMVELScriptParamsList(context);
        for (int i = 0; i < this.names.length; ++i) {
            paramsList.put(this.names[i], this.evaluators[i].evaluate(eventsPerStream, isNewData, context));
        }
        return this.evaluateInternal(paramsList);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(this.returnType, ExprNodeScriptEvalMVEL.class, codegenClassScope);
        CodegenMember member = codegenClassScope.makeAddMember(ExprNodeScriptEvalMVEL.class, this);
        CodegenExpressionRef refExprEvalCtx = exprSymbol.getAddExprEvalCtx(methodNode);
        CodegenBlock block = methodNode.getBlock().declareVar(Map.class, "paramsList", CodegenExpressionBuilder.staticMethod(ExprNodeScriptEvalMVEL.class, "getMVELScriptParamsList", refExprEvalCtx));
        for (int i = 0; i < this.names.length; ++i) {
            block.expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("paramsList"), "put", CodegenExpressionBuilder.constant(this.names[i]), this.parameters[i].evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope)));
        }
        CodegenExpression scriptResult = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(member.getMemberId()), "evaluateInternal", CodegenExpressionBuilder.ref("paramsList"));
        if (requiredType == Object.class) {
            block.methodReturn(scriptResult);
        } else {
            block.methodReturn(CodegenExpressionBuilder.cast(this.returnType, scriptResult));
        }
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return this.names.length == 0 ? ExprForgeComplexityEnum.SINGLE : ExprForgeComplexityEnum.INTER;
    }

    @Override
    public Class getEvaluationType() {
        return this.returnType;
    }

    @Override
    public Object evaluate(Object[] lookupValues, ExprEvaluatorContext context) {
        Map<String, Object> paramsList = ExprNodeScriptEvalMVEL.getMVELScriptParamsList(context);
        for (int i = 0; i < this.names.length; ++i) {
            paramsList.put(this.names[i], lookupValues[i]);
        }
        return this.evaluateInternal(paramsList);
    }

    public static Map<String, Object> getMVELScriptParamsList(ExprEvaluatorContext context) {
        HashMap<String, Object> paramsList = new HashMap<String, Object>();
        paramsList.put("epl", context.getAllocateAgentInstanceScriptContext());
        return paramsList;
    }

    public Object evaluateInternal(Map<String, Object> paramsList) {
        try {
            Object result = MVELInvoker.executeExpression(this.executable, paramsList);
            if (this.coercer != null) {
                return this.coercer.coerceBoxed((Number)result);
            }
            return result;
        }
        catch (InvocationTargetException ex) {
            Throwable mvelException = ex.getCause();
            String message = "Unexpected exception executing script '" + this.parent.getScript().getName() + "' for statement '" + this.statementName + "' : " + mvelException.getMessage();
            log.error(message, mvelException);
            throw new EPException(message, ex);
        }
    }
}

