/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.script.jsr223;

import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.ExpressionScriptProvided;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR223Helper {
    private static final Logger log = LoggerFactory.getLogger(JSR223Helper.class);

    public static CompiledScript verifyCompileScript(ExpressionScriptProvided script, String dialect) throws ExprValidationException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(dialect);
        if (engine == null) {
            throw new ExprValidationException("Failed to obtain script engine for dialect '" + dialect + "' for script '" + script.getName() + "'");
        }
        engine.put("javax.script.filename", script.getName());
        Compilable compilingEngine = (Compilable)((Object)engine);
        try {
            return compilingEngine.compile(script.getExpression());
        }
        catch (ScriptException ex) {
            String message = "Exception compiling script '" + script.getName() + "' of dialect '" + dialect + "': " + JSR223Helper.getScriptCompileMsg(ex);
            log.info(message, (Throwable)ex);
            throw new ExprValidationException(message, ex);
        }
    }

    public static String getScriptCompileMsg(ScriptException ex) {
        if (ex.getLineNumber() != 1 && ex.getColumnNumber() != -1) {
            return "At line " + ex.getLineNumber() + " column " + ex.getColumnNumber() + ": " + ex.getMessage();
        }
        return ex.getMessage();
    }
}

