/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.util;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.annotation.EventRepresentation;
import com.espertech.esper.client.util.EventUnderlyingType;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import java.lang.annotation.Annotation;

public class EventRepresentationUtil {
    public static EventUnderlyingType getRepresentation(Annotation[] annotations, ConfigurationInformation configs, CreateSchemaDesc.AssignedType assignedType) {
        if (assignedType == CreateSchemaDesc.AssignedType.OBJECTARRAY) {
            return EventUnderlyingType.OBJECTARRAY;
        }
        if (assignedType == CreateSchemaDesc.AssignedType.MAP) {
            return EventUnderlyingType.MAP;
        }
        if (assignedType == CreateSchemaDesc.AssignedType.AVRO) {
            return EventUnderlyingType.AVRO;
        }
        if (assignedType == CreateSchemaDesc.AssignedType.VARIANT || assignedType != CreateSchemaDesc.AssignedType.NONE) {
            throw new IllegalStateException("Not handled by event representation: " + (Object)((Object)assignedType));
        }
        Annotation annotation = AnnotationUtil.findAnnotation(annotations, EventRepresentation.class);
        if (annotation != null) {
            EventRepresentation eventRepresentation = (EventRepresentation)annotation;
            if (eventRepresentation.value() == EventUnderlyingType.AVRO) {
                return EventUnderlyingType.AVRO;
            }
            if (eventRepresentation.value() == EventUnderlyingType.OBJECTARRAY) {
                return EventUnderlyingType.OBJECTARRAY;
            }
            if (eventRepresentation.value() == EventUnderlyingType.MAP) {
                return EventUnderlyingType.MAP;
            }
            throw new IllegalStateException("Unrecognized enum " + (Object)((Object)eventRepresentation.value()));
        }
        EventUnderlyingType configured = configs.getEngineDefaults().getEventMeta().getDefaultEventRepresentation();
        if (configured == EventUnderlyingType.OBJECTARRAY) {
            return EventUnderlyingType.OBJECTARRAY;
        }
        if (configured == EventUnderlyingType.MAP) {
            return EventUnderlyingType.MAP;
        }
        if (configured == EventUnderlyingType.AVRO) {
            return EventUnderlyingType.AVRO;
        }
        return EventUnderlyingType.MAP;
    }
}

