/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.codegen.ExprNodeCompiler;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledCrontab;
import com.espertech.esper.epl.view.OutputConditionPolledCrontabState;
import com.espertech.esper.epl.view.OutputConditionPolledFactory;
import com.espertech.esper.epl.view.OutputConditionPolledState;
import com.espertech.esper.schedule.ScheduleParameterException;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.schedule.ScheduleSpecUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputConditionPolledCrontabFactory
implements OutputConditionPolledFactory {
    private final ExprEvaluator[] expressions;
    private static final Logger log = LoggerFactory.getLogger(OutputConditionPolledCrontabFactory.class);

    public OutputConditionPolledCrontabFactory(List<ExprNode> scheduleSpecExpressionList, StatementContext statementContext) throws ExprValidationException {
        ExprValidationContext validationContext = new ExprValidationContext(new StreamTypeServiceImpl(statementContext.getEngineURI(), false), statementContext.getEngineImportService(), statementContext.getStatementExtensionServicesContext(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext.getTableService(), new ExprEvaluatorContextStatement(statementContext, false), statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, false, false, null, false);
        this.expressions = new ExprEvaluator[scheduleSpecExpressionList.size()];
        int count = 0;
        for (ExprNode parameters : scheduleSpecExpressionList) {
            ExprNode node = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.OUTPUTLIMIT, parameters, validationContext);
            this.expressions[count++] = ExprNodeCompiler.allocateEvaluator(node.getForge(), statementContext.getEngineImportService(), this.getClass(), false, statementContext.getStatementName());
        }
    }

    @Override
    public OutputConditionPolled makeNew(AgentInstanceContext agentInstanceContext) {
        ScheduleSpec scheduleSpec;
        try {
            Object[] scheduleSpecParameterList = OutputConditionPolledCrontabFactory.evaluate(this.expressions, agentInstanceContext);
            scheduleSpec = ScheduleSpecUtil.computeValues(scheduleSpecParameterList);
        }
        catch (ScheduleParameterException e) {
            throw new IllegalArgumentException("Invalid schedule specification : " + e.getMessage(), e);
        }
        OutputConditionPolledCrontabState state = new OutputConditionPolledCrontabState(scheduleSpec, null, 0L);
        return new OutputConditionPolledCrontab(agentInstanceContext, state);
    }

    @Override
    public OutputConditionPolled makeFromState(AgentInstanceContext agentInstanceContext, OutputConditionPolledState state) {
        return new OutputConditionPolledCrontab(agentInstanceContext, (OutputConditionPolledCrontabState)state);
    }

    private static Object[] evaluate(ExprEvaluator[] parameters, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] results = new Object[parameters.length];
        int count = 0;
        for (ExprEvaluator expr : parameters) {
            try {
                results[count] = expr.evaluate(null, true, exprEvaluatorContext);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = "Failed expression evaluation in crontab timer-at for parameter " + count + ": " + ex.getMessage();
                log.error(message, (Throwable)ex);
                throw new IllegalArgumentException(message);
            }
        }
        return results;
    }
}

