/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.ConfigurationEventTypeAvro;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeMap;
import com.espertech.esper.client.ConfigurationEventTypeObjectArray;
import com.espertech.esper.client.ConfigurationEventTypeWithSupertype;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.client.util.EventUnderlyingType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.engineimport.EngineImportException;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.spec.ColumnDesc;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import com.espertech.esper.epl.util.EventRepresentationUtil;
import com.espertech.esper.event.BaseNestableEventType;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.EventTypeNestableGetterFactory;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.PropertySetDescriptor;
import com.espertech.esper.event.PropertySetDescriptorItem;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.event.avro.AvroSchemaEventType;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.property.DynamicProperty;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.NestedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyBase;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.event.property.SimpleProperty;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.StringValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTypeUtility {
    private static final Logger log = LoggerFactory.getLogger(EventTypeUtility.class);

    public static Map<String, Object> getPropertyTypesNonPrimitive(Map<String, Object> propertyTypesMayPrimitive) {
        boolean hasPrimitive = false;
        for (Map.Entry<String, Object> entry : propertyTypesMayPrimitive.entrySet()) {
            if (!(entry.getValue() instanceof Class) || !((Class)entry.getValue()).isPrimitive()) continue;
            hasPrimitive = true;
            break;
        }
        if (!hasPrimitive) {
            return propertyTypesMayPrimitive;
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(propertyTypesMayPrimitive);
        for (Map.Entry<String, Object> entry : propertyTypesMayPrimitive.entrySet()) {
            Class clazz;
            if (!(entry.getValue() instanceof Class) || !(clazz = (Class)entry.getValue()).isPrimitive()) continue;
            props.put(entry.getKey(), JavaClassHelper.getBoxedType(clazz));
        }
        return props;
    }

    public static EventType requireEventType(String aspectCamel, String aspectName, EventAdapterService eventAdapterService, String optionalEventTypeName) throws ExprValidationException {
        if (optionalEventTypeName == null) {
            throw new ExprValidationException(aspectCamel + " '" + aspectName + "' returns EventBean-array but does not provide the event type name");
        }
        EventType eventType = eventAdapterService.getExistsTypeByName(optionalEventTypeName);
        if (eventType == null) {
            throw new ExprValidationException(aspectCamel + " '" + aspectName + "' returns event type '" + optionalEventTypeName + "' and the event type cannot be found");
        }
        return eventType;
    }

    public static Pair<EventType[], Set<EventType>> getSuperTypesDepthFirst(ConfigurationEventTypeWithSupertype optionalConfig, EventUnderlyingType representation, Map<String, ? extends EventType> nameToTypeMap) {
        return EventTypeUtility.getSuperTypesDepthFirst(optionalConfig == null ? null : optionalConfig.getSuperTypes(), representation, nameToTypeMap);
    }

    public static Pair<EventType[], Set<EventType>> getSuperTypesDepthFirst(Set<String> superTypesSet, EventUnderlyingType representation, Map<String, ? extends EventType> nameToTypeMap) throws EventAdapterException {
        if (superTypesSet == null || superTypesSet.isEmpty()) {
            return new Pair<Object, Object>(null, null);
        }
        EventType[] superTypes = new EventType[superTypesSet.size()];
        LinkedHashSet<EventType> deepSuperTypes = new LinkedHashSet<EventType>();
        int count = 0;
        for (String superName : superTypesSet) {
            EventType type = nameToTypeMap.get(superName);
            if (type == null) {
                throw new EventAdapterException("Supertype by name '" + superName + "' could not be found");
            }
            if (representation == EventUnderlyingType.MAP) {
                if (!(type instanceof MapEventType)) {
                    throw new EventAdapterException("Supertype by name '" + superName + "' is not a Map, expected a Map event type as a supertype");
                }
            } else if (representation == EventUnderlyingType.OBJECTARRAY) {
                if (!(type instanceof ObjectArrayEventType)) {
                    throw new EventAdapterException("Supertype by name '" + superName + "' is not an Object-array type, expected a Object-array event type as a supertype");
                }
            } else if (representation == EventUnderlyingType.AVRO) {
                if (!(type instanceof AvroSchemaEventType)) {
                    throw new EventAdapterException("Supertype by name '" + superName + "' is not an Avro type, expected a Avro event type as a supertype");
                }
            } else {
                throw new IllegalStateException("Unrecognized enum " + (Object)((Object)representation));
            }
            superTypes[count++] = type;
            deepSuperTypes.add(type);
            EventTypeUtility.addRecursiveSupertypes(deepSuperTypes, type);
        }
        ArrayList superTypesListDepthFirst = new ArrayList(deepSuperTypes);
        Collections.reverse(superTypesListDepthFirst);
        return new Pair<EventType[], Set<EventType>>(superTypes, new LinkedHashSet(superTypesListDepthFirst));
    }

    public static EventPropertyDescriptor getNestablePropertyDescriptor(EventType target, String propertyName) {
        EventPropertyDescriptor descriptor = target.getPropertyDescriptor(propertyName);
        if (descriptor != null) {
            return descriptor;
        }
        int index = StringValue.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            return null;
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (property instanceof PropertyBase) {
            return target.getPropertyDescriptor(((PropertyBase)property).getPropertyNameAtomic());
        }
        if (!(property instanceof NestedProperty)) {
            return null;
        }
        NestedProperty nested = (NestedProperty)property;
        ArrayDeque<Property> properties = new ArrayDeque<Property>(nested.getProperties());
        return EventTypeUtility.getNestablePropertyDescriptor(target, properties);
    }

    public static EventPropertyDescriptor getNestablePropertyDescriptor(EventType target, Deque<Property> stack) {
        Property topProperty = stack.removeFirst();
        if (stack.isEmpty()) {
            return target.getPropertyDescriptor(((PropertyBase)topProperty).getPropertyNameAtomic());
        }
        if (!(topProperty instanceof SimpleProperty)) {
            return null;
        }
        SimpleProperty simple = (SimpleProperty)topProperty;
        FragmentEventType fragmentEventType = target.getFragmentType(simple.getPropertyNameAtomic());
        if (fragmentEventType == null || fragmentEventType.getFragmentType() == null) {
            return null;
        }
        return EventTypeUtility.getNestablePropertyDescriptor(fragmentEventType.getFragmentType(), stack);
    }

    public static LinkedHashMap<String, Object> buildType(List<ColumnDesc> columns, EventAdapterService eventAdapterService, Set<String> copyFrom, EngineImportService engineImportService) throws ExprValidationException {
        LinkedHashMap<String, Object> typing = new LinkedHashMap<String, Object>();
        HashSet<String> columnNames = new HashSet<String>();
        if (copyFrom != null && !copyFrom.isEmpty()) {
            for (String copyFromName : copyFrom) {
                EventType type = eventAdapterService.getExistsTypeByName(copyFromName);
                if (type == null) {
                    throw new ExprValidationException("Type by name '" + copyFromName + "' could not be located");
                }
                EventTypeUtility.mergeType(typing, type, columnNames);
            }
        }
        for (ColumnDesc column : columns) {
            boolean added = columnNames.add(column.getName());
            if (!added) {
                throw new ExprValidationException("Duplicate column name '" + column.getName() + "'");
            }
            Object columnType = EventTypeUtility.buildType(column, engineImportService);
            typing.put(column.getName(), columnType);
        }
        return typing;
    }

    public static Object buildType(ColumnDesc column, EngineImportService engineImportService) throws ExprValidationException {
        if (column.getType() == null) {
            return null;
        }
        if (column.isPrimitiveArray()) {
            Class primitive = JavaClassHelper.getPrimitiveClassForName(column.getType());
            if (primitive != null) {
                return Array.newInstance(primitive, 0).getClass();
            }
            throw new ExprValidationException("Type '" + column.getType() + "' is not a primitive type");
        }
        Class<?> plain = JavaClassHelper.getClassForSimpleName(column.getType(), engineImportService.getClassForNameProvider());
        if (plain != null) {
            if (column.isArray()) {
                plain = Array.newInstance(plain, 0).getClass();
            }
            return plain;
        }
        Class<?> resolved = null;
        try {
            resolved = engineImportService.resolveClass(column.getType(), false);
        }
        catch (EngineImportException engineImportException) {
            // empty catch block
        }
        if (resolved == null) {
            try {
                resolved = JavaClassHelper.getClassForName(column.getType(), engineImportService.getClassForNameProvider());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (resolved != null) {
            if (column.isArray()) {
                resolved = Array.newInstance(resolved, 0).getClass();
            }
            return resolved;
        }
        if (column.isArray()) {
            return column.getType() + "[]";
        }
        return column.getType();
    }

    private static void mergeType(Map<String, Object> typing, EventType typeToMerge, Set<String> columnNames) throws ExprValidationException {
        for (EventPropertyDescriptor prop : typeToMerge.getPropertyDescriptors()) {
            Object existing = typing.get(prop.getPropertyName());
            if (!prop.isFragment()) {
                Class assigned = prop.getPropertyType();
                if (existing != null && existing instanceof Class && JavaClassHelper.getBoxedType((Class)existing) != JavaClassHelper.getBoxedType(assigned)) {
                    throw new ExprValidationException("Type by name '" + typeToMerge.getName() + "' contributes property '" + prop.getPropertyName() + "' defined as '" + JavaClassHelper.getClassNameFullyQualPretty(assigned) + "' which overides the same property of type '" + JavaClassHelper.getClassNameFullyQualPretty((Class)existing) + "'");
                }
                typing.put(prop.getPropertyName(), prop.getPropertyType());
            } else {
                if (existing != null) {
                    throw new ExprValidationException("Property by name '" + prop.getPropertyName() + "' is defined twice by adding type '" + typeToMerge.getName() + "'");
                }
                FragmentEventType fragment = typeToMerge.getFragmentType(prop.getPropertyName());
                if (fragment == null) continue;
                if (fragment.isIndexed()) {
                    typing.put(prop.getPropertyName(), new EventType[]{fragment.getFragmentType()});
                } else {
                    typing.put(prop.getPropertyName(), fragment.getFragmentType());
                }
            }
            columnNames.add(prop.getPropertyName());
        }
    }

    public static void validateTimestampProperties(EventType eventType, String startTimestampProperty, String endTimestampProperty) throws ConfigurationException {
        Class type;
        if (startTimestampProperty != null) {
            if (eventType.getGetter(startTimestampProperty) == null) {
                throw new ConfigurationException("Declared start timestamp property name '" + startTimestampProperty + "' was not found");
            }
            type = eventType.getPropertyType(startTimestampProperty);
            if (!JavaClassHelper.isDatetimeClass(type)) {
                throw new ConfigurationException("Declared start timestamp property '" + startTimestampProperty + "' is expected to return a Date, Calendar or long-typed value but returns '" + type.getName() + "'");
            }
        }
        if (endTimestampProperty != null) {
            if (startTimestampProperty == null) {
                throw new ConfigurationException("Declared end timestamp property requires that a start timestamp property is also declared");
            }
            if (eventType.getGetter(endTimestampProperty) == null) {
                throw new ConfigurationException("Declared end timestamp property name '" + endTimestampProperty + "' was not found");
            }
            type = eventType.getPropertyType(endTimestampProperty);
            if (!JavaClassHelper.isDatetimeClass(type)) {
                throw new ConfigurationException("Declared end timestamp property '" + endTimestampProperty + "' is expected to return a Date, Calendar or long-typed value but returns '" + type.getName() + "'");
            }
            Class startType = eventType.getPropertyType(startTimestampProperty);
            if (JavaClassHelper.getBoxedType(startType) != JavaClassHelper.getBoxedType(type)) {
                throw new ConfigurationException("Declared end timestamp property '" + endTimestampProperty + "' is expected to have the same property type as the start-timestamp property '" + startTimestampProperty + "'");
            }
        }
    }

    public static boolean isTypeOrSubTypeOf(EventType candidate, EventType superType) {
        if (candidate == superType) {
            return true;
        }
        if (candidate.getSuperTypes() != null) {
            Iterator<EventType> it = candidate.getDeepSuperTypes();
            while (it.hasNext()) {
                if (it.next() != superType) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, Object> compileMapTypeProperties(Map<String, Object> typing, EventAdapterService eventAdapterService) {
        LinkedHashMap<String, Object> compiled = new LinkedHashMap<String, Object>(typing);
        for (Map.Entry<String, Object> specifiedEntry : typing.entrySet()) {
            EventType eventType;
            Object typeSpec = specifiedEntry.getValue();
            String nameSpec = specifiedEntry.getKey();
            if (typeSpec instanceof Class) {
                compiled.put(nameSpec, JavaClassHelper.getBoxedType((Class)typeSpec));
                continue;
            }
            if (!(typeSpec instanceof String)) continue;
            String typeNameSpec = (String)typeSpec;
            boolean isArray = EventTypeUtility.isPropertyArray(typeNameSpec);
            if (isArray) {
                typeNameSpec = EventTypeUtility.getPropertyRemoveArray(typeNameSpec);
            }
            if ((eventType = eventAdapterService.getExistsTypeByName(typeNameSpec)) == null || !(eventType instanceof BeanEventType)) continue;
            BeanEventType beanEventType = (BeanEventType)eventType;
            Class underlyingType = beanEventType.getUnderlyingType();
            if (isArray) {
                underlyingType = JavaClassHelper.getArrayType(underlyingType);
            }
            compiled.put(nameSpec, underlyingType);
        }
        return compiled;
    }

    public static boolean isPropertyArray(String name) {
        return name.trim().endsWith("[]");
    }

    public static boolean isTypeOrSubTypeOf(String typeName, EventType sameTypeOrSubtype) {
        if (sameTypeOrSubtype.getName().equals(typeName)) {
            return true;
        }
        if (sameTypeOrSubtype.getSuperTypes() == null) {
            return false;
        }
        for (EventType superType : sameTypeOrSubtype.getSuperTypes()) {
            if (!superType.getName().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public static String getPropertyRemoveArray(String name) {
        return name.replaceAll("\\[", "").replaceAll("\\]", "");
    }

    /*
     * WARNING - void declaration
     */
    public static PropertySetDescriptor getNestableProperties(Map<String, Object> propertiesToAdd, EventAdapterService eventAdapterService, EventTypeNestableGetterFactory factory, EventType[] optionalSuperTypes) throws EPException {
        ArrayList<String> propertyNameList = new ArrayList<String>();
        ArrayList<EventPropertyDescriptor> propertyDescriptors = new ArrayList<EventPropertyDescriptor>();
        LinkedHashMap<String, Object> nestableTypes = new LinkedHashMap<String, Object>();
        HashMap<String, PropertySetDescriptorItem> propertyItems = new HashMap<String, PropertySetDescriptorItem>();
        if (optionalSuperTypes != null) {
            for (int i = 0; i < optionalSuperTypes.length; ++i) {
                BaseNestableEventType superType = (BaseNestableEventType)optionalSuperTypes[i];
                for (String string : superType.getPropertyNames()) {
                    if (nestableTypes.containsKey(string)) continue;
                    propertyNameList.add(string);
                }
                for (EventPropertyDescriptor eventPropertyDescriptor : superType.getPropertyDescriptors()) {
                    if (nestableTypes.containsKey(eventPropertyDescriptor.getPropertyName())) continue;
                    propertyDescriptors.add(eventPropertyDescriptor);
                }
                propertyItems.putAll(superType.propertyItems);
                nestableTypes.putAll(superType.nestableTypes);
            }
        }
        nestableTypes.putAll(propertiesToAdd);
        for (Map.Entry<String, Object> entry : propertiesToAdd.entrySet()) {
            EventType eventType;
            EventPropertyGetterSPI getter;
            String value;
            Class clazz;
            if (!(entry.getKey() instanceof String)) {
                throw new EPException("Invalid type configuration: property name is not a String-type value");
            }
            String name = entry.getKey();
            if (entry.getValue() instanceof String && (clazz = JavaClassHelper.getPrimitiveClassForName(value = entry.getValue().toString().trim())) != null) {
                entry.setValue(clazz);
            }
            if (entry.getValue() instanceof Class) {
                void var13_32;
                boolean isMapped;
                Class classType = (Class)entry.getValue();
                boolean isArray = classType.isArray();
                Object var13_28 = null;
                if (isArray) {
                    Class<?> clazz2 = classType.getComponentType();
                }
                if (isMapped = JavaClassHelper.isImplementsInterface(classType, Map.class)) {
                    Class<Object> clazz3 = Object.class;
                }
                boolean isFragment = JavaClassHelper.isFragmentableType(classType);
                BeanEventType nativeFragmentType = null;
                FragmentEventType fragmentType = null;
                if (isFragment) {
                    fragmentType = EventBeanUtility.createNativeFragmentType(classType, null, eventAdapterService);
                    if (fragmentType != null) {
                        nativeFragmentType = (BeanEventType)fragmentType.getFragmentType();
                    } else {
                        isFragment = false;
                    }
                }
                EventPropertyGetterSPI getter2 = factory.getGetterProperty(name, nativeFragmentType, eventAdapterService);
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, classType, (Class)var13_32, false, false, isArray, isMapped, isFragment);
                PropertySetDescriptorItem item2 = new PropertySetDescriptorItem(descriptor, classType, getter2, fragmentType);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, item2);
                continue;
            }
            if (entry.getValue() == null) {
                getter = factory.getGetterProperty(name, null, null);
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, null, null, false, false, false, false, false);
                PropertySetDescriptorItem propertySetDescriptorItem = new PropertySetDescriptorItem(descriptor, null, getter, null);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, propertySetDescriptorItem);
                continue;
            }
            if (entry.getValue() instanceof Map) {
                getter = factory.getGetterProperty(name, null, null);
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, Map.class, null, false, false, false, true, false);
                PropertySetDescriptorItem propertySetDescriptorItem = new PropertySetDescriptorItem(descriptor, Map.class, getter, null);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, propertySetDescriptorItem);
                continue;
            }
            if (entry.getValue() instanceof EventType) {
                eventType = (EventType)entry.getValue();
                EventPropertyGetterSPI getter3 = factory.getGetterEventBean(name, eventType.getUnderlyingType());
                EventPropertyDescriptor eventPropertyDescriptor = new EventPropertyDescriptor(name, eventType.getUnderlyingType(), null, false, false, false, false, true);
                FragmentEventType fragmentEventType = new FragmentEventType(eventType, false, false);
                PropertySetDescriptorItem item3 = new PropertySetDescriptorItem(eventPropertyDescriptor, eventType.getUnderlyingType(), getter3, fragmentEventType);
                propertyNameList.add(name);
                propertyDescriptors.add(eventPropertyDescriptor);
                propertyItems.put(name, item3);
                continue;
            }
            if (entry.getValue() instanceof EventType[]) {
                eventType = ((EventType[])entry.getValue())[0];
                Object prototypeArray = Array.newInstance(eventType.getUnderlyingType(), 0);
                EventPropertyGetterSPI eventPropertyGetterSPI = factory.getGetterEventBeanArray(name, eventType);
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, prototypeArray.getClass(), eventType.getUnderlyingType(), false, false, true, false, true);
                FragmentEventType fragmentEventType = new FragmentEventType(eventType, true, false);
                PropertySetDescriptorItem item4 = new PropertySetDescriptorItem(descriptor, prototypeArray.getClass(), eventPropertyGetterSPI, fragmentEventType);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, item4);
                continue;
            }
            if (entry.getValue() instanceof String) {
                EventPropertyGetterSPI getter2;
                EventType eventType2;
                String propertyName = entry.getValue().toString();
                boolean isArray = EventTypeUtility.isPropertyArray(propertyName);
                if (isArray) {
                    propertyName = EventTypeUtility.getPropertyRemoveArray(propertyName);
                }
                if (!((eventType2 = eventAdapterService.getExistsTypeByName(propertyName)) instanceof BaseNestableEventType) && !(eventType2 instanceof BeanEventType)) {
                    throw new EPException("Nestable type configuration encountered an unexpected property type name '" + entry.getValue() + "' for property '" + name + "', expected java.lang.Class or java.util.Map or the name of a previously-declared Map or ObjectArray type");
                }
                Class<?> underlyingType = eventType2.getUnderlyingType();
                Class<?> propertyComponentType = null;
                if (isArray) {
                    propertyComponentType = underlyingType;
                    if (underlyingType != Object[].class) {
                        underlyingType = Array.newInstance(underlyingType, 0).getClass();
                    }
                }
                if (!isArray) {
                    EventPropertyGetterSPI getter5 = factory.getGetterBeanNested(name, eventType2, eventAdapterService);
                } else {
                    getter2 = factory.getGetterBeanNestedArray(name, eventType2, eventAdapterService);
                }
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, underlyingType, propertyComponentType, false, false, isArray, false, true);
                FragmentEventType fragmentEventType = new FragmentEventType(eventType2, isArray, false);
                PropertySetDescriptorItem item5 = new PropertySetDescriptorItem(descriptor, underlyingType, getter2, fragmentEventType);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, item5);
                continue;
            }
            EventTypeUtility.generateExceptionNestedProp(name, entry.getValue());
        }
        return new PropertySetDescriptor(propertyNameList, propertyDescriptors, propertyItems, nestableTypes);
    }

    private static void generateExceptionNestedProp(String name, Object value) throws EPException {
        String clazzName = value == null ? "null" : value.getClass().getSimpleName();
        throw new EPException("Nestable type configuration encountered an unexpected property type of '" + clazzName + "' for property '" + name + "', expected java.lang.Class or java.util.Map or the name of a previously-declared Map or ObjectArray type");
    }

    public static Class getNestablePropertyType(String propertyName, Map<String, PropertySetDescriptorItem> simplePropertyTypes, Map<String, Object> nestableTypes, EventAdapterService eventAdapterService) {
        Object nestedType;
        PropertySetDescriptorItem item = simplePropertyTypes.get(ASTUtil.unescapeDot(propertyName));
        if (item != null) {
            return item.getSimplePropertyType();
        }
        int index = StringValue.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            if (propertyName.endsWith("?")) {
                return Object.class;
            }
            Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
            if (property instanceof SimpleProperty) {
                PropertySetDescriptorItem propitem = simplePropertyTypes.get(propertyName);
                if (propitem != null) {
                    return propitem.getSimplePropertyType();
                }
                return null;
            }
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof EventType[]) {
                    return ((EventType[])type)[0].getUnderlyingType();
                }
                if (type instanceof String) {
                    EventType innerType;
                    String propTypeName = type.toString();
                    boolean isArray = EventTypeUtility.isPropertyArray(propTypeName);
                    if (isArray) {
                        propTypeName = EventTypeUtility.getPropertyRemoveArray(propTypeName);
                    }
                    return (innerType = eventAdapterService.getExistsTypeByName(propTypeName)) == null ? null : innerType.getUnderlyingType();
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                return ((Class)type).getComponentType();
            }
            if (property instanceof MappedProperty) {
                MappedProperty mappedProp = (MappedProperty)property;
                Object type = nestableTypes.get(mappedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
                    return Object.class;
                }
                return null;
            }
            return null;
        }
        String propertyMap = ASTUtil.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        boolean isRootedDynamic = false;
        if (propertyMap.endsWith("?")) {
            propertyMap = propertyMap.substring(0, propertyMap.length() - 1);
            isRootedDynamic = true;
        }
        if ((nestedType = nestableTypes.get(propertyMap)) == null) {
            Property property = PropertyParser.parseAndWalkLaxToSimple(propertyMap);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof String) {
                    EventType innerType;
                    String propTypeName = type.toString();
                    boolean isArray = EventTypeUtility.isPropertyArray(propTypeName);
                    if (isArray) {
                        propTypeName = EventTypeUtility.getPropertyRemoveArray(propTypeName);
                    }
                    if (!((innerType = eventAdapterService.getExistsTypeByName(propTypeName)) instanceof BaseNestableEventType)) {
                        return null;
                    }
                    return innerType.getPropertyType(propertyNested);
                }
                if (type instanceof EventType[]) {
                    EventType innerType = ((EventType[])type)[0];
                    return innerType.getPropertyType(propertyNested);
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                Class<?> componentType = ((Class)type).getComponentType();
                EventType nestedEventType = eventAdapterService.addBeanType(componentType.getName(), componentType, false, false, false);
                return nestedEventType.getPropertyType(propertyNested);
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            return isRootedDynamic ? Object.class : null;
        }
        if (nestedType == Map.class) {
            Property prop = PropertyParser.parseAndWalk(propertyNested, isRootedDynamic);
            return isRootedDynamic ? Object.class : JavaClassHelper.getBoxedType(prop.getPropertyTypeMap(null, eventAdapterService));
        }
        if (nestedType instanceof Map) {
            Property prop = PropertyParser.parseAndWalk(propertyNested, isRootedDynamic);
            Map nestedTypes = (Map)nestedType;
            return isRootedDynamic ? Object.class : JavaClassHelper.getBoxedType(prop.getPropertyTypeMap(nestedTypes, eventAdapterService));
        }
        if (nestedType instanceof Class) {
            Class simpleClass = (Class)nestedType;
            if (JavaClassHelper.isJavaBuiltinDataType(simpleClass)) {
                return null;
            }
            if (simpleClass.isArray() && (JavaClassHelper.isJavaBuiltinDataType(simpleClass.getComponentType()) || simpleClass.getComponentType() == Object.class)) {
                return null;
            }
            EventType nestedEventType = eventAdapterService.addBeanType(simpleClass.getName(), simpleClass, false, false, false);
            return isRootedDynamic ? Object.class : JavaClassHelper.getBoxedType(nestedEventType.getPropertyType(propertyNested));
        }
        if (nestedType instanceof EventType) {
            EventType innerType = (EventType)nestedType;
            return isRootedDynamic ? Object.class : JavaClassHelper.getBoxedType(innerType.getPropertyType(propertyNested));
        }
        if (nestedType instanceof EventType[]) {
            return null;
        }
        if (nestedType instanceof String) {
            EventType innerType;
            String nestedName = nestedType.toString();
            boolean isArray = EventTypeUtility.isPropertyArray(nestedName);
            if (isArray) {
                nestedName = EventTypeUtility.getPropertyRemoveArray(nestedName);
            }
            if (!((innerType = eventAdapterService.getExistsTypeByName(nestedName)) instanceof BaseNestableEventType)) {
                return null;
            }
            return isRootedDynamic ? Object.class : JavaClassHelper.getBoxedType(innerType.getPropertyType(propertyNested));
        }
        String message = "Nestable map type configuration encountered an unexpected value type of '" + nestedType.getClass() + "' for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
        throw new PropertyAccessException(message);
    }

    public static EventPropertyGetterSPI getNestableGetter(String propertyName, Map<String, PropertySetDescriptorItem> propertyGetters, Map<String, EventPropertyGetterSPI> propertyGetterCache, Map<String, Object> nestableTypes, EventAdapterService eventAdapterService, EventTypeNestableGetterFactory factory, boolean isObjectArray) {
        Object nestedType;
        EventPropertyGetterSPI cachedGetter = propertyGetterCache.get(propertyName);
        if (cachedGetter != null) {
            return cachedGetter;
        }
        String unescapePropName = ASTUtil.unescapeDot(propertyName);
        PropertySetDescriptorItem item = propertyGetters.get(unescapePropName);
        if (item != null) {
            EventPropertyGetterSPI getter = item.getPropertyGetter();
            propertyGetterCache.put(propertyName, getter);
            return getter;
        }
        int index = StringValue.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyName);
            if (prop instanceof DynamicProperty) {
                EventPropertyGetterSPI getterDyn = factory.getPropertyProvidedGetter(nestableTypes, propertyName, prop, eventAdapterService);
                propertyGetterCache.put(propertyName, getterDyn);
                return getterDyn;
            }
            if (prop instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)prop;
                Object type = nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof EventType[]) {
                    EventPropertyGetterSPI getterArr = factory.getGetterIndexedEventBean(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex());
                    propertyGetterCache.put(propertyName, getterArr);
                    return getterArr;
                }
                if (type instanceof String) {
                    EventType innerType;
                    String nestedTypeName = type.toString();
                    boolean isArray = EventTypeUtility.isPropertyArray(nestedTypeName);
                    if (isArray) {
                        nestedTypeName = EventTypeUtility.getPropertyRemoveArray(nestedTypeName);
                    }
                    if (!((innerType = eventAdapterService.getExistsTypeByName(nestedTypeName)) instanceof BaseNestableEventType)) {
                        return null;
                    }
                    EventPropertyGetterSPI typeGetter = !isArray ? factory.getGetterBeanNested(indexedProp.getPropertyNameAtomic(), innerType, eventAdapterService) : factory.getGetterIndexedUnderlyingArray(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), eventAdapterService, innerType);
                    propertyGetterCache.put(propertyName, typeGetter);
                    return typeGetter;
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                Class<?> componentType = ((Class)type).getComponentType();
                EventPropertyGetterSPI indexedGetter = factory.getGetterIndexedPOJO(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), eventAdapterService, componentType);
                propertyGetterCache.put(propertyName, indexedGetter);
                return indexedGetter;
            }
            if (prop instanceof MappedProperty) {
                MappedProperty mappedProp = (MappedProperty)prop;
                Object type = nestableTypes.get(mappedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
                    return factory.getGetterMappedProperty(mappedProp.getPropertyNameAtomic(), mappedProp.getKey());
                }
                return null;
            }
            return null;
        }
        String propertyMap = ASTUtil.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        boolean isRootedDynamic = false;
        if (propertyMap.endsWith("?")) {
            propertyMap = propertyMap.substring(0, propertyMap.length() - 1);
            isRootedDynamic = true;
        }
        if ((nestedType = nestableTypes.get(propertyMap)) == null) {
            Property property = PropertyParser.parseAndWalkLaxToSimple(propertyMap);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof String) {
                    EventPropertyGetterSPI typeGetter;
                    EventTypeSPI innerType;
                    String nestedTypeName = type.toString();
                    boolean isArray = EventTypeUtility.isPropertyArray(nestedTypeName);
                    if (isArray) {
                        nestedTypeName = EventTypeUtility.getPropertyRemoveArray(nestedTypeName);
                    }
                    if (!((innerType = (EventTypeSPI)eventAdapterService.getExistsTypeByName(nestedTypeName)) instanceof BaseNestableEventType)) {
                        return null;
                    }
                    if (!isArray) {
                        typeGetter = factory.getGetterNestedEntryBean(propertyMap, innerType.getGetter(propertyNested), innerType, eventAdapterService);
                    } else {
                        EventPropertyGetterSPI innerGetter = innerType.getGetterSPI(propertyNested);
                        if (innerGetter == null) {
                            return null;
                        }
                        typeGetter = factory.getGetterNestedEntryBeanArray(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), innerGetter, innerType, eventAdapterService);
                    }
                    propertyGetterCache.put(propertyName, typeGetter);
                    return typeGetter;
                }
                if (type instanceof EventType[]) {
                    EventTypeSPI componentType = (EventTypeSPI)((EventType[])type)[0];
                    EventPropertyGetterSPI nestedGetter = componentType.getGetterSPI(propertyNested);
                    if (nestedGetter == null) {
                        return null;
                    }
                    EventPropertyGetterSPI typeGetter = factory.getGetterIndexedEntryEventBeanArrayElement(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), nestedGetter);
                    propertyGetterCache.put(propertyName, typeGetter);
                    return typeGetter;
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                Class<?> componentType = ((Class)type).getComponentType();
                EventTypeSPI nestedEventType = (EventTypeSPI)eventAdapterService.addBeanType(componentType.getName(), componentType, false, false, false);
                BeanEventPropertyGetter nestedGetter = (BeanEventPropertyGetter)nestedEventType.getGetterSPI(propertyNested);
                if (nestedGetter == null) {
                    return null;
                }
                Class propertyTypeGetter = nestedEventType.getPropertyType(propertyNested);
                EventPropertyGetterSPI indexGetter = factory.getGetterIndexedEntryPOJO(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), nestedGetter, eventAdapterService, propertyTypeGetter);
                propertyGetterCache.put(propertyName, indexGetter);
                return indexGetter;
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            if (isRootedDynamic) {
                Property prop = PropertyParser.parseAndWalk(propertyNested, true);
                if (!isObjectArray) {
                    MapEventPropertyGetter getterNested = prop.getGetterMap(null, eventAdapterService);
                    EventPropertyGetterSPI dynamicGetter = factory.getGetterNestedPropertyProvidedGetterDynamic(nestableTypes, propertyMap, getterNested, eventAdapterService);
                    propertyGetterCache.put(propertyName, dynamicGetter);
                    return dynamicGetter;
                }
                return null;
            }
            return null;
        }
        if (nestedType == Map.class) {
            Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyNested);
            MapEventPropertyGetter getterNestedMap = prop.getGetterMap(null, eventAdapterService);
            if (getterNestedMap == null) {
                return null;
            }
            EventPropertyGetterSPI mapGetter = factory.getGetterNestedMapProp(propertyMap, getterNestedMap);
            propertyGetterCache.put(propertyName, mapGetter);
            return mapGetter;
        }
        if (nestedType instanceof Map) {
            Map nestedTypes;
            Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyNested);
            MapEventPropertyGetter getterNestedMap = prop.getGetterMap(nestedTypes = (Map)nestedType, eventAdapterService);
            if (getterNestedMap == null) {
                return null;
            }
            EventPropertyGetterSPI mapGetter = factory.getGetterNestedMapProp(propertyMap, getterNestedMap);
            propertyGetterCache.put(propertyName, mapGetter);
            return mapGetter;
        }
        if (nestedType instanceof Class) {
            Class propertyComponentType;
            Class propertyType;
            Class simpleClass = (Class)nestedType;
            if (simpleClass.isArray()) {
                return null;
            }
            EventTypeSPI nestedEventType = (EventTypeSPI)eventAdapterService.addBeanType(simpleClass.getName(), simpleClass, false, false, false);
            BeanEventPropertyGetter nestedGetter = (BeanEventPropertyGetter)nestedEventType.getGetterSPI(propertyNested);
            if (nestedGetter == null) {
                return null;
            }
            EventPropertyDescriptor desc = nestedEventType.getPropertyDescriptor(propertyNested);
            if (desc == null) {
                propertyType = nestedEventType.getPropertyType(propertyNested);
                propertyComponentType = propertyType.isArray() ? propertyType.getComponentType() : JavaClassHelper.getGenericType(propertyType, 0);
            } else {
                propertyType = desc.getPropertyType();
                propertyComponentType = desc.getPropertyComponentType();
            }
            EventPropertyGetterSPI getter = factory.getGetterNestedPOJOProp(propertyMap, nestedGetter, eventAdapterService, propertyType, propertyComponentType);
            propertyGetterCache.put(propertyName, getter);
            return getter;
        }
        if (nestedType instanceof EventType) {
            EventTypeSPI innerType = (EventTypeSPI)nestedType;
            EventPropertyGetterSPI nestedGetter = innerType.getGetterSPI(propertyNested);
            if (nestedGetter == null) {
                return null;
            }
            EventPropertyGetterSPI getter = factory.getGetterNestedEventBean(propertyMap, nestedGetter);
            propertyGetterCache.put(propertyName, getter);
            return getter;
        }
        if (nestedType instanceof EventType[]) {
            EventType[] typeArray = (EventType[])nestedType;
            EventPropertyGetterSPI beanArrGetter = factory.getGetterEventBeanArray(propertyMap, typeArray[0]);
            propertyGetterCache.put(propertyName, beanArrGetter);
            return beanArrGetter;
        }
        if (nestedType instanceof String) {
            EventType innerType;
            String nestedName = nestedType.toString();
            boolean isArray = EventTypeUtility.isPropertyArray(nestedName);
            if (isArray) {
                nestedName = EventTypeUtility.getPropertyRemoveArray(nestedName);
            }
            if (!((innerType = eventAdapterService.getExistsTypeByName(nestedName)) instanceof BaseNestableEventType)) {
                return null;
            }
            EventPropertyGetterSPI innerGetter = ((EventTypeSPI)innerType).getGetterSPI(propertyNested);
            if (innerGetter == null) {
                return null;
            }
            EventPropertyGetterSPI outerGetter = !isArray ? factory.getGetterNestedEntryBean(propertyMap, innerGetter, innerType, eventAdapterService) : factory.getGetterNestedEntryBeanArray(propertyMap, 0, innerGetter, innerType, eventAdapterService);
            propertyGetterCache.put(propertyName, outerGetter);
            return outerGetter;
        }
        String message = "Nestable type configuration encountered an unexpected value type of '" + nestedType.getClass() + " for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
        throw new PropertyAccessException(message);
    }

    public static LinkedHashMap<String, Object> validateObjectArrayDef(String[] propertyNames, Object[] propertyTypes) {
        if (propertyNames.length != propertyTypes.length) {
            throw new ConfigurationException("Number of property names and property types do not match, found " + propertyNames.length + " property names and " + propertyTypes.length + " property types");
        }
        HashSet<String> propertyNamesSet = new HashSet<String>();
        LinkedHashMap<String, Object> propertyTypesMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (propertyNamesSet.contains(propertyName)) {
                throw new ConfigurationException("Property '" + propertyName + "' is listed twice in the type definition");
            }
            propertyNamesSet.add(propertyName);
            propertyTypesMap.put(propertyName, propertyTypes[i]);
        }
        return propertyTypesMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventType createNonVariantType(boolean isAnonymous, CreateSchemaDesc spec, Annotation[] annotations, ConfigurationInformation configSnapshot, EventAdapterService eventAdapterService, EngineImportService engineImportService) throws ExprValidationException {
        if (spec.getAssignedType() == CreateSchemaDesc.AssignedType.VARIANT) {
            throw new IllegalStateException("Variant type is not allowed in this context");
        }
        if (spec.getTypes().isEmpty()) {
            ConfigurationEventTypeWithSupertype config;
            EventUnderlyingType representation = EventRepresentationUtil.getRepresentation(annotations, configSnapshot, spec.getAssignedType());
            LinkedHashMap<String, Object> typing = EventTypeUtility.buildType(spec.getColumns(), eventAdapterService, spec.getCopyFrom(), engineImportService);
            Map<String, Object> compiledTyping = EventTypeUtility.compileMapTypeProperties(typing, eventAdapterService);
            if (representation == EventUnderlyingType.MAP) {
                config = new ConfigurationEventTypeMap();
            } else if (representation == EventUnderlyingType.OBJECTARRAY) {
                config = new ConfigurationEventTypeObjectArray();
            } else {
                if (representation != EventUnderlyingType.AVRO) throw new IllegalStateException("Unrecognized representation '" + (Object)((Object)representation) + "'");
                config = new ConfigurationEventTypeAvro();
            }
            if (spec.getInherits() != null) {
                config.getSuperTypes().addAll(spec.getInherits());
            }
            config.setStartTimestampPropertyName(spec.getStartTimestampProperty());
            config.setEndTimestampPropertyName(spec.getEndTimestampProperty());
            if (representation == EventUnderlyingType.MAP) {
                if (!isAnonymous) return eventAdapterService.addNestableMapType(spec.getSchemaName(), compiledTyping, (ConfigurationEventTypeMap)config, false, false, true, false, false);
                return eventAdapterService.createAnonymousMapType(spec.getSchemaName(), compiledTyping, true);
            }
            if (representation == EventUnderlyingType.OBJECTARRAY) {
                if (!isAnonymous) return eventAdapterService.addNestableObjectArrayType(spec.getSchemaName(), compiledTyping, (ConfigurationEventTypeObjectArray)config, false, false, true, false, false, false, null);
                return eventAdapterService.createAnonymousObjectArrayType(spec.getSchemaName(), compiledTyping);
            }
            if (representation != EventUnderlyingType.AVRO) throw new IllegalStateException("Unrecognized representation " + (Object)((Object)representation));
            if (!isAnonymous) return eventAdapterService.addAvroType(spec.getSchemaName(), compiledTyping, false, false, true, false, false, annotations, (ConfigurationEventTypeAvro)config, null, null);
            return eventAdapterService.createAnonymousAvroType(spec.getSchemaName(), compiledTyping, annotations, null, null);
        }
        if (spec.getCopyFrom() != null && !spec.getCopyFrom().isEmpty()) {
            throw new ExprValidationException("Copy-from types are not allowed with class-provided types");
        }
        if (spec.getTypes().size() != 1) {
            throw new IllegalStateException("Multiple types provided");
        }
        String typeName = spec.getTypes().iterator().next();
        try {
            ConfigurationEventTypeLegacy config = eventAdapterService.getClassLegacyConfigs(typeName);
            if (spec.getStartTimestampProperty() != null || spec.getEndTimestampProperty() != null) {
                if (config == null) {
                    config = new ConfigurationEventTypeLegacy();
                }
                config.setStartTimestampPropertyName(spec.getStartTimestampProperty());
                config.setEndTimestampPropertyName(spec.getEndTimestampProperty());
                eventAdapterService.setClassLegacyConfigs(Collections.singletonMap(typeName, config));
            }
            if (!isAnonymous) return eventAdapterService.addBeanType(spec.getSchemaName(), spec.getTypes().iterator().next(), false, false, false, true);
            String className = spec.getTypes().iterator().next();
            try {
                Class clazz = engineImportService.resolveClass(className, false);
                return eventAdapterService.createAnonymousBeanType(spec.getSchemaName(), clazz);
            }
            catch (EngineImportException e) {
                throw new ExprValidationException("Failed to resolve class '" + className + "': " + e.getMessage(), e);
            }
        }
        catch (EventAdapterException ex) {
            try {
                Class clazz = engineImportService.resolveClass(typeName, false);
                if (!isAnonymous) return eventAdapterService.addBeanType(spec.getSchemaName(), clazz, false, false, true);
                return eventAdapterService.createAnonymousBeanType(spec.getSchemaName(), clazz);
            }
            catch (EngineImportException e) {
                log.debug("Engine import failed to resolve event type '" + typeName + "'");
                throw ex;
            }
        }
    }

    public static WriteablePropertyDescriptor findWritable(String propertyName, Set<WriteablePropertyDescriptor> writables) {
        for (WriteablePropertyDescriptor writable : writables) {
            if (!writable.getPropertyName().equals(propertyName)) continue;
            return writable;
        }
        return null;
    }

    public static TimestampPropertyDesc validatedDetermineTimestampProps(EventType type, String startProposed, String endProposed, EventType[] superTypes) throws EPException {
        String startTimestampPropertyName = startProposed;
        String endTimestampPropertyName = endProposed;
        if (superTypes != null && superTypes.length > 0) {
            for (EventType superType : superTypes) {
                if (superType.getStartTimestampPropertyName() != null) {
                    if (startTimestampPropertyName != null && !startTimestampPropertyName.equals(superType.getStartTimestampPropertyName())) {
                        throw EventTypeUtility.getExceptionTimestampInherited("start", startTimestampPropertyName, superType.getStartTimestampPropertyName(), superType);
                    }
                    startTimestampPropertyName = superType.getStartTimestampPropertyName();
                }
                if (superType.getEndTimestampPropertyName() == null) continue;
                if (endTimestampPropertyName != null && !endTimestampPropertyName.equals(superType.getEndTimestampPropertyName())) {
                    throw EventTypeUtility.getExceptionTimestampInherited("end", endTimestampPropertyName, superType.getEndTimestampPropertyName(), superType);
                }
                endTimestampPropertyName = superType.getEndTimestampPropertyName();
            }
        }
        EventTypeUtility.validateTimestampProperties(type, startTimestampPropertyName, endTimestampPropertyName);
        return new TimestampPropertyDesc(startTimestampPropertyName, endTimestampPropertyName);
    }

    private static EPException getExceptionTimestampInherited(String tstype, String firstName, String secondName, EventType superType) {
        String message = "Event type declares " + tstype + " timestamp as property '" + firstName + "' however inherited event type '" + superType.getName() + "' declares " + tstype + " timestamp as property '" + secondName + "'";
        return new EPException(message);
    }

    private static void addRecursiveSupertypes(Set<EventType> superTypes, EventType child) {
        if (child.getSuperTypes() != null) {
            for (int i = 0; i < child.getSuperTypes().length; ++i) {
                superTypes.add(child.getSuperTypes()[i]);
                EventTypeUtility.addRecursiveSupertypes(superTypes, child.getSuperTypes()[i]);
            }
        }
    }

    public static String disallowedAtTypeMessage() {
        return "The @type annotation is only allowed when the invocation target returns EventBean instances";
    }

    public static void validateEventBeanClassVisibility(Class clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new EventAdapterException("Event class '" + clazz.getName() + "' does not have public visibility");
        }
    }

    public static class TimestampPropertyDesc {
        private final String start;
        private final String end;

        public TimestampPropertyDesc(String start, String end) {
            this.start = start;
            this.end = end;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }
    }
}

