/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.arr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.arr.ObjectArrayEventPropertyGetterAndIndexed;

public class ObjectArrayArrayPropertyGetter
implements ObjectArrayEventPropertyGetterAndIndexed {
    private final int propertyIndex;
    private final int index;
    private final EventAdapterService eventAdapterService;
    private final EventType fragmentType;

    public ObjectArrayArrayPropertyGetter(int propertyIndex, int index, EventAdapterService eventAdapterService, EventType fragmentType) {
        this.propertyIndex = propertyIndex;
        this.index = index;
        this.fragmentType = fragmentType;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        return true;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        return this.getObjectArrayInternal(array, this.index);
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.getObjectArrayInternal(array, index);
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(obj);
        return this.getObjectArray(array);
    }

    private Object getObjectArrayInternal(Object[] array, int index) throws PropertyAccessException {
        Object value = array[this.propertyIndex];
        return BaseNestableEventUtil.getBNArrayValueAtIndexWithNullCheck(value, index);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean obj) throws PropertyAccessException {
        Object fragmentUnderlying = this.get(obj);
        return BaseNestableEventUtil.getBNFragmentNonPojo(fragmentUnderlying, this.fragmentType, this.eventAdapterService);
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNArrayValueAtIndexWithNullCheck", CodegenExpressionBuilder.arrayAtIndex(underlyingExpression, CodegenExpressionBuilder.constant(this.propertyIndex)), CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMember mSvc = codegenClassScope.makeAddMember(EventAdapterService.class, this.eventAdapterService);
        CodegenMember mType = codegenClassScope.makeAddMember(EventType.class, this.fragmentType);
        return CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNFragmentNonPojo", this.underlyingGetCodegen(underlyingExpression, codegenMethodScope, codegenClassScope), CodegenExpressionBuilder.member(mType.getMemberId()), CodegenExpressionBuilder.member(mSvc.getMemberId()));
    }

    @Override
    public CodegenExpression eventBeanGetIndexedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
        return CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNArrayValueAtIndexWithNullCheck", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), CodegenExpressionBuilder.constant(this.propertyIndex)), key);
    }
}

