/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Iterator;

public abstract class BaseNativePropertyGetter
implements EventPropertyGetterSPI {
    private final EventAdapterService eventAdapterService;
    private volatile BeanEventType fragmentEventType;
    private final Class fragmentClassType;
    private boolean isFragmentable;
    private final boolean isArray;
    private final boolean isIterable;

    public abstract Class getTargetType();

    public abstract Class getBeanPropType();

    public static Object toFragmentArray(Object[] object, BeanEventType fragmentEventType, EventAdapterService eventAdapterService) {
        EventBean[] events = new EventBean[object.length];
        int countFilled = 0;
        for (int i = 0; i < object.length; ++i) {
            Object element = Array.get(object, i);
            if (element == null) continue;
            events[countFilled] = eventAdapterService.adapterForTypedBean(element, fragmentEventType);
            ++countFilled;
        }
        if (countFilled == object.length) {
            return events;
        }
        if (countFilled == 0) {
            return new EventBean[0];
        }
        EventBean[] returnVal = new EventBean[countFilled];
        System.arraycopy(events, 0, returnVal, 0, countFilled);
        return returnVal;
    }

    public static Object getFragmentDynamic(Object object, EventAdapterService eventAdapterService) {
        if (object == null) {
            return null;
        }
        BeanEventType fragmentEventType = null;
        boolean isArray = false;
        if (object.getClass().isArray()) {
            if (JavaClassHelper.isFragmentableType(object.getClass().getComponentType())) {
                isArray = true;
                fragmentEventType = eventAdapterService.getBeanEventTypeFactory().createBeanTypeDefaultName(object.getClass().getComponentType());
            }
        } else if (JavaClassHelper.isFragmentableType(object.getClass())) {
            fragmentEventType = eventAdapterService.getBeanEventTypeFactory().createBeanTypeDefaultName(object.getClass());
        }
        if (fragmentEventType == null) {
            return null;
        }
        if (isArray) {
            int len = Array.getLength(object);
            EventBean[] events = new EventBean[len];
            int countFilled = 0;
            for (int i = 0; i < len; ++i) {
                Object element = Array.get(object, i);
                if (element == null) continue;
                events[countFilled] = eventAdapterService.adapterForTypedBean(element, fragmentEventType);
                ++countFilled;
            }
            if (countFilled == len) {
                return events;
            }
            if (countFilled == 0) {
                return new EventBean[0];
            }
            EventBean[] returnVal = new EventBean[countFilled];
            System.arraycopy(events, 0, returnVal, 0, countFilled);
            return returnVal;
        }
        return eventAdapterService.adapterForTypedBean(object, fragmentEventType);
    }

    public static Object toFragmentIterable(Object object, BeanEventType fragmentEventType, EventAdapterService eventAdapterService) {
        if (!(object instanceof Iterable)) {
            return null;
        }
        Iterator iterator = ((Iterable)object).iterator();
        if (!iterator.hasNext()) {
            return new EventBean[0];
        }
        ArrayDeque<EventBean> events = new ArrayDeque<EventBean>();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next == null) continue;
            events.add(eventAdapterService.adapterForTypedBean(next, fragmentEventType));
        }
        return events.toArray(new EventBean[events.size()]);
    }

    public BaseNativePropertyGetter(EventAdapterService eventAdapterService, Class returnType, Class genericType) {
        this.eventAdapterService = eventAdapterService;
        if (returnType.isArray()) {
            this.fragmentClassType = returnType.getComponentType();
            this.isArray = true;
            this.isIterable = false;
        } else if (JavaClassHelper.isImplementsInterface(returnType, Iterable.class)) {
            this.fragmentClassType = genericType;
            this.isArray = false;
            this.isIterable = true;
        } else {
            this.fragmentClassType = returnType;
            this.isArray = false;
            this.isIterable = false;
        }
        this.isFragmentable = true;
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        this.determineFragmentable();
        if (!this.isFragmentable) {
            return null;
        }
        Object object = this.get(eventBean);
        if (object == null) {
            return null;
        }
        if (this.isArray) {
            return BaseNativePropertyGetter.toFragmentArray((Object[])object, this.fragmentEventType, this.eventAdapterService);
        }
        if (this.isIterable) {
            return BaseNativePropertyGetter.toFragmentIterable(object, this.fragmentEventType, this.eventAdapterService);
        }
        return this.eventAdapterService.adapterForTypedBean(object, this.fragmentEventType);
    }

    private CodegenMethodNode getFragmentCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMember msvc = codegenClassScope.makeAddMember(EventAdapterService.class, this.eventAdapterService);
        CodegenMember mtype = codegenClassScope.makeAddMember(BeanEventType.class, this.fragmentEventType);
        CodegenBlock block = codegenMethodScope.makeChild(Object.class, this.getClass(), codegenClassScope).addParam(this.getTargetType(), "underlying").getBlock().declareVar(this.getBeanPropType(), "object", this.underlyingGetCodegen(CodegenExpressionBuilder.ref("underlying"), codegenMethodScope, codegenClassScope)).ifRefNullReturnNull("object");
        if (this.isArray) {
            return block.methodReturn(CodegenExpressionBuilder.staticMethod(BaseNativePropertyGetter.class, "toFragmentArray", CodegenExpressionBuilder.cast(Object[].class, (CodegenExpression)CodegenExpressionBuilder.ref("object")), CodegenExpressionBuilder.member(mtype.getMemberId()), CodegenExpressionBuilder.member(msvc.getMemberId())));
        }
        if (this.isIterable) {
            return block.methodReturn(CodegenExpressionBuilder.staticMethod(BaseNativePropertyGetter.class, "toFragmentIterable", CodegenExpressionBuilder.ref("object"), CodegenExpressionBuilder.member(mtype.getMemberId()), CodegenExpressionBuilder.member(msvc.getMemberId())));
        }
        return block.methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(msvc.getMemberId()), "adapterForTypedBean", CodegenExpressionBuilder.ref("object"), CodegenExpressionBuilder.member(mtype.getMemberId())));
    }

    @Override
    public final CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        this.determineFragmentable();
        if (!this.isFragmentable) {
            return CodegenExpressionBuilder.constantNull();
        }
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public final CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        this.determineFragmentable();
        if (!this.isFragmentable) {
            return CodegenExpressionBuilder.constantNull();
        }
        return CodegenExpressionBuilder.localMethod(this.getFragmentCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    private void determineFragmentable() {
        if (this.fragmentEventType == null) {
            if (JavaClassHelper.isFragmentableType(this.fragmentClassType)) {
                this.fragmentEventType = this.eventAdapterService.getBeanEventTypeFactory().createBeanTypeDefaultName(this.fragmentClassType);
            } else {
                this.isFragmentable = false;
            }
        }
    }
}

