/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.event.EventPropertyWriter;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanEventPropertyWriter
implements EventPropertyWriter {
    private static final Logger log = LoggerFactory.getLogger(BeanEventPropertyWriter.class);
    private final Class clazz;
    private final FastMethod writerMethod;

    public BeanEventPropertyWriter(Class clazz, FastMethod writerMethod) {
        this.clazz = clazz;
        this.writerMethod = writerMethod;
    }

    @Override
    public void write(Object value, EventBean target) {
        this.invoke(new Object[]{value}, target.getUnderlying());
    }

    public void writeValue(Object value, Object target) {
        this.invoke(new Object[]{value}, target);
    }

    protected void invoke(Object[] values, Object target) {
        try {
            this.writerMethod.invoke(target, values);
        }
        catch (InvocationTargetException e) {
            String message = "Unexpected exception encountered invoking setter-method '" + this.writerMethod.getJavaMethod() + "' on class '" + this.clazz.getName() + "' : " + e.getTargetException().getMessage();
            log.error(message, (Throwable)e);
        }
    }
}

