/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.event.bean.BeanInstantiator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInstantiatorByCtor
implements BeanInstantiator {
    private static final Logger log = LoggerFactory.getLogger(BeanInstantiatorByCtor.class);
    private final Constructor ctor;

    public BeanInstantiatorByCtor(Constructor ctor) {
        this.ctor = ctor;
    }

    @Override
    public Object instantiate() {
        try {
            return this.ctor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            String message = "Unexpected exception encountered invoking constructor '" + this.ctor.getName() + "' on class '" + this.ctor.getDeclaringClass().getName() + "': " + e.getTargetException().getMessage();
            log.error(message, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException ex) {
            return this.handle(ex);
        }
        catch (InstantiationException ex) {
            return this.handle(ex);
        }
    }

    private Object handle(Exception e) {
        String message = "Unexpected exception encountered invoking newInstance on class '" + this.ctor.getDeclaringClass().getName() + "': " + e.getMessage();
        log.error(message, (Throwable)e);
        return null;
    }
}

