/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.DynamicPropertyDescriptor;
import com.espertech.esper.event.bean.DynamicPropertyGetterBase;
import com.espertech.esper.event.bean.PropertyHelper;
import com.espertech.esper.event.vaevent.PropertyUtility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class DynamicMappedPropertyGetter
extends DynamicPropertyGetterBase {
    private final String getterMethodName;
    private final Object[] parameters;

    public DynamicMappedPropertyGetter(String fieldName, String key, EventAdapterService eventAdapterService) {
        super(eventAdapterService);
        this.getterMethodName = PropertyHelper.getGetterMethodName(fieldName);
        this.parameters = new Object[]{key};
    }

    @Override
    public Method determineMethod(Class clazz) throws PropertyAccessException {
        try {
            return clazz.getMethod(this.getterMethodName, String.class);
        }
        catch (NoSuchMethodException ex1) {
            Method method;
            try {
                method = clazz.getMethod(this.getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            if (method.getReturnType() != Map.class) {
                return null;
            }
            return method;
        }
    }

    @Override
    protected Object call(DynamicPropertyDescriptor descriptor, Object underlying) {
        try {
            if (descriptor.isHasParameters()) {
                return descriptor.getMethod().invoke(underlying, this.parameters);
            }
            Object result = descriptor.getMethod().invoke(underlying, null);
            if (result instanceof Map && result != null) {
                Map map = (Map)result;
                return map.get(this.parameters[0]);
            }
            return null;
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod().getJavaMethod(), underlying, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod().getJavaMethod(), e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod().getJavaMethod(), e);
        }
    }
}

