/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.util.Map;

public class MapEntryPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyName;
    private final EventAdapterService eventAdapterService;
    private final BeanEventType eventType;

    public MapEntryPropertyGetter(String propertyName, BeanEventType eventType, EventAdapterService eventAdapterService) {
        this.propertyName = propertyName;
        this.eventAdapterService = eventAdapterService;
        this.eventType = eventType;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object value = map.get(this.propertyName);
        if (value instanceof EventBean) {
            return ((EventBean)value).getUnderlying();
        }
        return value;
    }

    private CodegenExpression getMapCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethodNode method = codegenMethodScope.makeChild(Object.class, MapEntryPropertyGetter.class, codegenClassScope).addParam(Map.class, "map").getBlock().declareVar(Object.class, "value", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("map"), "get", CodegenExpressionBuilder.constant(this.propertyName))).ifInstanceOf("value", EventBean.class).blockReturn(CodegenExpressionBuilder.exprDotUnderlying(CodegenExpressionBuilder.cast(EventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("value")))).methodReturn(CodegenExpressionBuilder.ref("value"));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        return this.getMap(BaseNestableEventUtil.checkedCastUnderlyingMap(obj));
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        if (this.eventType == null) {
            return null;
        }
        Object result = this.get(eventBean);
        return BaseNestableEventUtil.getBNFragmentPojo(result, this.eventType, this.eventAdapterService);
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(Map.class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (this.eventType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(Map.class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.getMapCodegen(underlyingExpression, codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotMethod(underlyingExpression, "containsKey", CodegenExpressionBuilder.constant(this.propertyName));
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (this.eventType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenMember mSvc = codegenClassScope.makeAddMember(EventAdapterService.class, this.eventAdapterService);
        CodegenMember mType = codegenClassScope.makeAddMember(BeanEventType.class, this.eventType);
        return CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNFragmentPojo", this.underlyingGetCodegen(underlyingExpression, codegenMethodScope, codegenClassScope), CodegenExpressionBuilder.member(mType.getMemberId()), CodegenExpressionBuilder.member(mSvc.getMemberId()));
    }
}

