/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.EventType;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.vaevent.VariantEventPropertyGetterAny;
import com.espertech.esper.event.vaevent.VariantEventPropertyGetterAnyWCast;
import com.espertech.esper.event.vaevent.VariantPropResolutionStrategy;
import com.espertech.esper.event.vaevent.VariantPropertyDesc;
import com.espertech.esper.event.vaevent.VariantPropertyGetterCache;
import com.espertech.esper.event.vaevent.VariantSpec;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleTypeCaster;
import com.espertech.esper.util.SimpleTypeCasterFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class VariantPropResolutionStrategyDefault
implements VariantPropResolutionStrategy {
    private int currentPropertyNumber;
    private VariantPropertyGetterCache propertyGetterCache;

    public VariantPropResolutionStrategyDefault(VariantSpec variantSpec) {
        this.propertyGetterCache = new VariantPropertyGetterCache(variantSpec.getEventTypes());
    }

    @Override
    public VariantPropertyDesc resolveProperty(String propertyName, EventType[] variants) {
        EventPropertyGetterSPI getter;
        boolean existsInAll = true;
        Class commonType = null;
        boolean mustCoerce = false;
        for (int i = 0; i < variants.length; ++i) {
            Class type = JavaClassHelper.getBoxedType(variants[i].getPropertyType(propertyName));
            if (type == null) {
                existsInAll = false;
                continue;
            }
            if (commonType == null) {
                commonType = type;
                continue;
            }
            if (type.equals(commonType)) continue;
            if (JavaClassHelper.isNumeric(type)) {
                if (JavaClassHelper.canCoerce(type, commonType)) {
                    mustCoerce = true;
                    continue;
                }
                if (JavaClassHelper.canCoerce(commonType, type)) {
                    mustCoerce = true;
                    commonType = type;
                }
            } else {
                if (commonType == Object.class) continue;
                if (!JavaClassHelper.isJavaBuiltinDataType(type)) {
                    Class superClassType2;
                    LinkedHashSet<Class> supersForType = new LinkedHashSet<Class>();
                    JavaClassHelper.getSuper(type, supersForType);
                    supersForType.remove(Object.class);
                    if (supersForType.contains(commonType)) continue;
                    if (JavaClassHelper.isSubclassOrImplementsInterface(commonType, type)) {
                        commonType = type;
                        continue;
                    }
                    LinkedHashSet<Class> supersForCommonType = new LinkedHashSet<Class>();
                    JavaClassHelper.getSuper(commonType, supersForCommonType);
                    supersForCommonType.remove(Object.class);
                    boolean found = false;
                    for (Class superClassType2 : supersForType) {
                        if (superClassType2.isInterface() || !supersForCommonType.contains(superClassType2)) continue;
                        commonType = superClassType2;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    Iterator iterator = supersForType.iterator();
                    while (!(!iterator.hasNext() || (superClassType2 = (Class)iterator.next()).isInterface() && supersForCommonType.contains(superClassType2))) {
                    }
                }
            }
            commonType = Object.class;
        }
        if (!existsInAll) {
            return null;
        }
        if (commonType == null) {
            return null;
        }
        int assignedPropertyNumber = this.currentPropertyNumber++;
        this.propertyGetterCache.addGetters(assignedPropertyNumber, propertyName);
        if (mustCoerce) {
            SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(null, commonType);
            getter = new VariantEventPropertyGetterAnyWCast(this.propertyGetterCache, assignedPropertyNumber, caster);
        } else {
            getter = new VariantEventPropertyGetterAny(this.propertyGetterCache, assignedPropertyNumber);
        }
        return new VariantPropertyDesc(commonType, getter, true);
    }
}

