/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.property.DynamicIndexedProperty;
import com.espertech.esper.event.property.DynamicMappedProperty;
import com.espertech.esper.event.property.DynamicSimpleProperty;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.NestedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.event.property.SimpleProperty;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.FragmentFactoryDOMGetter;
import com.espertech.esper.event.xml.SchemaElement;
import com.espertech.esper.event.xml.SchemaElementComplex;
import com.espertech.esper.event.xml.SchemaElementSimple;
import com.espertech.esper.event.xml.SchemaItem;
import com.espertech.esper.event.xml.SchemaItemAttribute;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.event.xml.SchemaUtil;
import com.espertech.esper.event.xml.XPathNamespaceContext;
import com.espertech.esper.event.xml.XPathPropertyGetter;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SchemaXMLPropertyParser {
    private static final Logger log = LoggerFactory.getLogger(SchemaXMLPropertyParser.class);

    public static EventPropertyGetterSPI getXPathResolution(String propertyName, XPathFactory xPathFactory, String rootElementName, String namespace, SchemaModel schemaModel, EventAdapterService eventAdapterService, BaseXMLEventType xmlEventType, boolean isAllowFragment, String defaultNamespace) throws EPException {
        XPathExpression expr;
        if (log.isDebugEnabled()) {
            log.debug("Determining XPath expression for property '" + propertyName + "'");
        }
        XPathNamespaceContext ctx = new XPathNamespaceContext();
        List<String> namespaces = schemaModel.getNamespaces();
        String defaultNamespacePrefix = null;
        for (int i = 0; i < namespaces.size(); ++i) {
            String prefix = "n" + i;
            ctx.addPrefix(prefix, namespaces.get(i));
            if (defaultNamespace == null || !defaultNamespace.equals(namespaces.get(i))) continue;
            defaultNamespacePrefix = prefix;
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        boolean isDynamic = property.isDynamic();
        SchemaElementComplex rootComplexElement = SchemaUtil.findRootElement(schemaModel, namespace, rootElementName);
        String prefix = ctx.getPrefix(rootComplexElement.getNamespace());
        prefix = prefix == null ? "" : prefix + ':';
        StringBuilder xPathBuf = new StringBuilder();
        xPathBuf.append('/');
        xPathBuf.append(prefix);
        if (rootElementName.startsWith("//")) {
            xPathBuf.append(rootElementName.substring(2));
        } else {
            xPathBuf.append(rootElementName);
        }
        SchemaElementComplex parentComplexElement = rootComplexElement;
        Pair<String, QName> pair = null;
        if (!(property instanceof NestedProperty)) {
            pair = SchemaXMLPropertyParser.makeProperty(rootComplexElement, property, ctx, true, isDynamic, defaultNamespacePrefix);
            if (pair == null) {
                throw new PropertyAccessException("Failed to locate property '" + propertyName + "' in schema");
            }
            xPathBuf.append(pair.getFirst());
        } else {
            NestedProperty nestedProperty = (NestedProperty)property;
            int indexLast = nestedProperty.getProperties().size() - 1;
            for (int i = 0; i < indexLast + 1; ++i) {
                boolean isLast = i == indexLast;
                Property propertyNested = nestedProperty.getProperties().get(i);
                pair = SchemaXMLPropertyParser.makeProperty(parentComplexElement, propertyNested, ctx, isLast, isDynamic, defaultNamespacePrefix);
                if (pair == null) {
                    throw new PropertyAccessException("Failed to locate property '" + propertyName + "' nested property part '" + property.getPropertyNameAtomic() + "' in schema");
                }
                String text = propertyNested.getPropertyNameAtomic();
                SchemaItem obj = SchemaUtil.findPropertyMapping(parentComplexElement, text);
                if (obj instanceof SchemaElementComplex) {
                    parentComplexElement = (SchemaElementComplex)obj;
                }
                xPathBuf.append(pair.getFirst());
            }
        }
        String xPath = xPathBuf.toString();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".parse XPath for property '" + propertyName + "' is expression=" + xPath);
        }
        XPath path = xPathFactory.newXPath();
        path.setNamespaceContext(ctx);
        if (log.isDebugEnabled()) {
            log.debug("Compiling XPath expression '" + xPath + "' for property '" + propertyName + "' using namespace context :" + ctx);
        }
        try {
            expr = path.compile(xPath);
        }
        catch (XPathExpressionException e) {
            String detail = "Error constructing XPath expression from property expression '" + propertyName + "' expression '" + xPath + "'";
            if (e.getMessage() != null) {
                throw new EPException(detail + " :" + e.getMessage(), e);
            }
            throw new EPException(detail, e);
        }
        SchemaItem item = property.getPropertyTypeSchema(rootComplexElement, eventAdapterService);
        if (item == null && !isDynamic) {
            return null;
        }
        Class resultType = !isDynamic ? SchemaUtil.toReturnType(item) : Node.class;
        FragmentFactoryDOMGetter fragmentFactory = null;
        if (isAllowFragment) {
            fragmentFactory = new FragmentFactoryDOMGetter(eventAdapterService, xmlEventType, propertyName);
        }
        return new XPathPropertyGetter(propertyName, xPath, expr, pair.getSecond(), resultType, fragmentFactory);
    }

    private static Pair<String, QName> makeProperty(SchemaElementComplex parent, Property property, XPathNamespaceContext ctx, boolean isLast, boolean isDynamic, String defaultNamespacePrefix) {
        String text = property.getPropertyNameAtomic();
        SchemaItem obj = SchemaUtil.findPropertyMapping(parent, text);
        if (obj instanceof SchemaElementSimple || obj instanceof SchemaElementComplex) {
            return SchemaXMLPropertyParser.makeElementProperty((SchemaElement)obj, property, ctx, isLast, isDynamic, defaultNamespacePrefix);
        }
        if (obj != null) {
            return SchemaXMLPropertyParser.makeAttributeProperty((SchemaItemAttribute)obj, property, ctx);
        }
        if (isDynamic) {
            return SchemaXMLPropertyParser.makeElementProperty(null, property, ctx, isLast, isDynamic, defaultNamespacePrefix);
        }
        return null;
    }

    private static Pair<String, QName> makeAttributeProperty(SchemaItemAttribute attribute, Property property, XPathNamespaceContext ctx) {
        String prefix = ctx.getPrefix(attribute.getNamespace());
        prefix = prefix == null ? "" : prefix + ':';
        if (SchemaXMLPropertyParser.isAnySimpleProperty(property)) {
            QName type = SchemaUtil.simpleTypeToQName(attribute.getXsSimpleType());
            String path = "/@" + prefix + property.getPropertyNameAtomic();
            return new Pair<String, QName>(path, type);
        }
        if (SchemaXMLPropertyParser.isAnyMappedProperty(property)) {
            throw new RuntimeException("Mapped properties not applicable to attributes");
        }
        throw new RuntimeException("Indexed properties not applicable to attributes");
    }

    private static Pair<String, QName> makeElementProperty(SchemaElement schemaElement, Property property, XPathNamespaceContext ctx, boolean isAlone, boolean isDynamic, String defaultNamespacePrefix) {
        SchemaElementComplex complex;
        QName type = isDynamic ? XPathConstants.NODE : (schemaElement instanceof SchemaElementSimple ? SchemaUtil.simpleTypeToQName(((SchemaElementSimple)schemaElement).getXsSimpleType()) : ((complex = (SchemaElementComplex)schemaElement).getOptionalSimpleType() != null ? SchemaUtil.simpleTypeToQName(complex.getOptionalSimpleType()) : XPathConstants.NODE));
        String prefix = !isDynamic ? ctx.getPrefix(schemaElement.getNamespace()) : defaultNamespacePrefix;
        prefix = prefix == null ? "" : prefix + ':';
        if (SchemaXMLPropertyParser.isAnySimpleProperty(property)) {
            if (!isDynamic && schemaElement.isArray() && !isAlone) {
                throw new PropertyAccessException("Simple property not allowed in repeating elements at '" + schemaElement.getName() + "'");
            }
            return new Pair<String, QName>('/' + prefix + property.getPropertyNameAtomic(), type);
        }
        if (SchemaXMLPropertyParser.isAnyMappedProperty(property)) {
            if (!isDynamic && !schemaElement.isArray()) {
                throw new PropertyAccessException("Element " + property.getPropertyNameAtomic() + " is not a collection, cannot be used as mapped property");
            }
            String key = SchemaXMLPropertyParser.getMappedPropertyKey(property);
            return new Pair<String, QName>('/' + prefix + property.getPropertyNameAtomic() + "[@id='" + key + "']", type);
        }
        if (!isDynamic && !schemaElement.isArray()) {
            throw new PropertyAccessException("Element " + property.getPropertyNameAtomic() + " is not a collection, cannot be used as mapped property");
        }
        int index = SchemaXMLPropertyParser.getIndexedPropertyIndex(property);
        int xPathPosition = index + 1;
        return new Pair<String, QName>('/' + prefix + property.getPropertyNameAtomic() + "[position() = " + xPathPosition + ']', type);
    }

    private static boolean isAnySimpleProperty(Property property) {
        return property instanceof SimpleProperty || property instanceof DynamicSimpleProperty;
    }

    private static boolean isAnyMappedProperty(Property property) {
        return property instanceof MappedProperty || property instanceof DynamicMappedProperty;
    }

    private static int getIndexedPropertyIndex(Property property) {
        return property instanceof IndexedProperty ? ((IndexedProperty)property).getIndex() : ((DynamicIndexedProperty)property).getIndex();
    }

    private static String getMappedPropertyKey(Property property) {
        return property instanceof MappedProperty ? ((MappedProperty)property).getKey() : ((DynamicMappedProperty)property).getKey();
    }
}

