/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterParamIndexStringRangeBase;
import com.espertech.esper.filterspec.FilterOperator;
import com.espertech.esper.filterspec.StringRange;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterParamIndexStringRangeInverted
extends FilterParamIndexStringRangeBase {
    private static final Logger log = LoggerFactory.getLogger(FilterParamIndexStringRangeInverted.class);

    public FilterParamIndexStringRangeInverted(ExprFilterSpecLookupable lookupable, ReadWriteLock readWriteLock, FilterOperator filterOperator) {
        super(lookupable, readWriteLock, filterOperator);
        if (!filterOperator.isInvertedRangeOperator()) {
            throw new IllegalArgumentException("Invalid filter operator " + (Object)((Object)filterOperator));
        }
    }

    @Override
    public final void matchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        Object objAttributeValue = this.lookupable.getGetter().get(theEvent);
        if (objAttributeValue == null) {
            return;
        }
        String attributeValue = (String)objAttributeValue;
        if (this.getFilterOperator() == FilterOperator.NOT_RANGE_CLOSED) {
            for (Map.Entry entry : this.ranges.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) <= 0 && ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) >= 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.NOT_RANGE_OPEN) {
            for (Map.Entry entry : this.ranges.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) < 0 && ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) > 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.NOT_RANGE_HALF_CLOSED) {
            for (Map.Entry entry : this.ranges.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) < 0 && ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) >= 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.NOT_RANGE_HALF_OPEN) {
            for (Map.Entry entry : this.ranges.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) <= 0 && ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) > 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else {
            throw new IllegalStateException("Invalid filter operator " + (Object)((Object)this.getFilterOperator()));
        }
    }
}

