/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.EventTypeIndexBuilderIndexLookupablePair;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterHandleSetNode;
import com.espertech.esper.filter.FilterParamIndexBase;
import com.espertech.esper.filter.FilterServiceGranularLockFactory;
import com.espertech.esper.filter.IndexFactory;
import com.espertech.esper.filter.IndexHelper;
import com.espertech.esper.filterspec.FilterValueSet;
import com.espertech.esper.filterspec.FilterValueSetParam;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayDeque;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexTreeBuilder {
    private static final Logger log = LoggerFactory.getLogger(IndexTreeBuilder.class);

    private IndexTreeBuilder() {
    }

    public static ArrayDeque<EventTypeIndexBuilderIndexLookupablePair>[] add(FilterValueSet filterValueSet, FilterHandle filterCallback, FilterHandleSetNode topNode, FilterServiceGranularLockFactory lockFactory) {
        ArrayDeque<EventTypeIndexBuilderIndexLookupablePair>[] treePathInfo;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".add (" + Thread.currentThread().getId() + ") Adding filter callback,   topNode=" + topNode + "  filterCallback=" + filterCallback);
        }
        if (filterValueSet.getParameters().length == 0) {
            treePathInfo = IndexTreeBuilder.allocateTreePath(1);
            treePathInfo[0] = new ArrayDeque(1);
            IndexTreeBuilder.addToNode(new ArrayDeque<FilterValueSetParam>(1), filterCallback, topNode, treePathInfo[0], lockFactory);
        } else {
            treePathInfo = IndexTreeBuilder.allocateTreePath(filterValueSet.getParameters().length);
            ArrayDeque<FilterValueSetParam> remainingParameters = new ArrayDeque<FilterValueSetParam>(4);
            for (int i = 0; i < filterValueSet.getParameters().length; ++i) {
                treePathInfo[i] = new ArrayDeque(filterValueSet.getParameters()[i].length);
                remainingParameters.clear();
                Collections.addAll(remainingParameters, filterValueSet.getParameters()[i]);
                IndexTreeBuilder.addToNode(remainingParameters, filterCallback, topNode, treePathInfo[i], lockFactory);
            }
        }
        return treePathInfo;
    }

    public static void remove(EventType eventType, FilterHandle filterCallback, EventTypeIndexBuilderIndexLookupablePair[] treePathInfo, FilterHandleSetNode topNode) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".remove (" + Thread.currentThread().getId() + ") Removing filterCallback  type " + eventType.getName() + " topNode=" + topNode + " filterCallback=" + filterCallback);
        }
        IndexTreeBuilder.removeFromNode(filterCallback, topNode, treePathInfo, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToNode(ArrayDeque<FilterValueSetParam> remainingParameters, FilterHandle filterCallback, FilterHandleSetNode currentNode, ArrayDeque<EventTypeIndexBuilderIndexLookupablePair> treePathInfo, FilterServiceGranularLockFactory lockFactory) {
        Pair<FilterValueSetParam, FilterParamIndexBase> pair;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".addToNode (" + Thread.currentThread().getId() + ") Adding filterCallback, node=" + currentNode + "  remainingParameters=" + IndexTreeBuilder.printRemainingParameters(remainingParameters));
        }
        if (remainingParameters.isEmpty()) {
            currentNode.getNodeRWLock().writeLock().lock();
            try {
                currentNode.add(filterCallback);
            }
            finally {
                currentNode.getNodeRWLock().writeLock().unlock();
            }
            return;
        }
        currentNode.getNodeRWLock().readLock().lock();
        try {
            pair = IndexHelper.findIndex(remainingParameters, currentNode.getIndizes());
            if (pair != null) {
                remainingParameters.remove(pair.getFirst());
                Object filterForValue = pair.getFirst().getFilterForValue();
                FilterParamIndexBase index = pair.getSecond();
                treePathInfo.add(new EventTypeIndexBuilderIndexLookupablePair(index, filterForValue));
                IndexTreeBuilder.addToIndex(remainingParameters, filterCallback, index, filterForValue, treePathInfo, lockFactory);
                return;
            }
        }
        finally {
            currentNode.getNodeRWLock().readLock().unlock();
        }
        currentNode.getNodeRWLock().writeLock().lock();
        try {
            pair = IndexHelper.findIndex(remainingParameters, currentNode.getIndizes());
            if (pair != null) {
                remainingParameters.remove(pair.getFirst());
                Object filterForValue = pair.getFirst().getFilterForValue();
                FilterParamIndexBase index = pair.getSecond();
                treePathInfo.add(new EventTypeIndexBuilderIndexLookupablePair(index, filterForValue));
                IndexTreeBuilder.addToIndex(remainingParameters, filterCallback, index, filterForValue, treePathInfo, lockFactory);
                return;
            }
            FilterValueSetParam parameterPickedForIndex = remainingParameters.removeFirst();
            FilterParamIndexBase index = IndexFactory.createIndex(parameterPickedForIndex.getLookupable(), lockFactory, parameterPickedForIndex.getFilterOperator());
            currentNode.getIndizes().add(index);
            treePathInfo.add(new EventTypeIndexBuilderIndexLookupablePair(index, parameterPickedForIndex.getFilterForValue()));
            IndexTreeBuilder.addToIndex(remainingParameters, filterCallback, index, parameterPickedForIndex.getFilterForValue(), treePathInfo, lockFactory);
        }
        finally {
            currentNode.getNodeRWLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeFromNode(FilterHandle filterCallback, FilterHandleSetNode currentNode, EventTypeIndexBuilderIndexLookupablePair[] treePathInfo, int treePathPosition) {
        EventTypeIndexBuilderIndexLookupablePair nextPair;
        EventTypeIndexBuilderIndexLookupablePair eventTypeIndexBuilderIndexLookupablePair = nextPair = treePathPosition < treePathInfo.length ? treePathInfo[treePathPosition++] : null;
        if (nextPair == null) {
            currentNode.getNodeRWLock().writeLock().lock();
            try {
                boolean isRemoved = currentNode.remove(filterCallback);
                boolean isEmpty = currentNode.isEmpty();
                if (!isRemoved) {
                    log.warn(".removeFromNode (" + Thread.currentThread().getId() + ") Could not find the filterCallback to be removed within the supplied node , node=" + currentNode + "  filterCallback=" + filterCallback);
                }
                boolean bl = isEmpty;
                return bl;
            }
            finally {
                currentNode.getNodeRWLock().writeLock().unlock();
            }
        }
        FilterParamIndexBase nextIndex = nextPair.getIndex();
        Object filteredForValue = nextPair.getLookupable();
        currentNode.getNodeRWLock().writeLock().lock();
        try {
            boolean isRemoved;
            boolean isEmpty = IndexTreeBuilder.removeFromIndex(filterCallback, nextIndex, treePathInfo, treePathPosition, filteredForValue);
            if (!isEmpty) {
                boolean bl = false;
                return bl;
            }
            if (nextIndex.isEmpty() && !(isRemoved = currentNode.remove(nextIndex))) {
                log.warn(".removeFromNode (" + Thread.currentThread().getId() + ") Could not find the index in index list for removal, index=" + nextIndex.toString() + "  filterCallback=" + filterCallback);
                boolean bl = false;
                return bl;
            }
            boolean bl = currentNode.isEmpty();
            return bl;
        }
        finally {
            currentNode.getNodeRWLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeFromIndex(FilterHandle filterCallback, FilterParamIndexBase index, EventTypeIndexBuilderIndexLookupablePair[] treePathInfo, int treePathPosition, Object filterForValue) {
        index.getReadWriteLock().writeLock().lock();
        try {
            EventTypeIndexBuilderIndexLookupablePair nextPair;
            EventEvaluator eventEvaluator = index.get(filterForValue);
            if (eventEvaluator == null) {
                log.warn(".removeFromIndex (" + Thread.currentThread().getId() + ") Could not find the filterCallback value in index, index=" + index.toString() + "  value=" + filterForValue.toString() + "  filterCallback=" + filterCallback);
                boolean bl = false;
                return bl;
            }
            if (eventEvaluator instanceof FilterHandleSetNode) {
                FilterHandleSetNode node = (FilterHandleSetNode)eventEvaluator;
                boolean isEmpty = IndexTreeBuilder.removeFromNode(filterCallback, node, treePathInfo, treePathPosition);
                if (isEmpty) {
                    index.remove(filterForValue);
                }
                boolean bl = index.isEmpty();
                return bl;
            }
            FilterParamIndexBase nextIndex = (FilterParamIndexBase)eventEvaluator;
            EventTypeIndexBuilderIndexLookupablePair eventTypeIndexBuilderIndexLookupablePair = nextPair = treePathPosition < treePathInfo.length ? treePathInfo[treePathPosition++] : null;
            if (nextPair == null) {
                log.error(".removeFromIndex Expected an inner index to this index, this=" + filterCallback.toString());
                assert (false);
                boolean bl = false;
                return bl;
            }
            if (nextPair.getIndex() != nextIndex) {
                log.error(".removeFromIndex Expected an index for filterCallback that differs from the found index, this=" + filterCallback.toString() + "  expected=" + nextPair.getIndex());
                assert (false);
                boolean bl = false;
                return bl;
            }
            Object nextExpressionValue = nextPair.getLookupable();
            boolean isEmpty = IndexTreeBuilder.removeFromIndex(filterCallback, nextPair.getIndex(), treePathInfo, treePathPosition, nextExpressionValue);
            if (isEmpty) {
                index.remove(filterForValue);
            }
            boolean bl = index.isEmpty();
            return bl;
        }
        finally {
            index.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToIndex(ArrayDeque<FilterValueSetParam> remainingParameters, FilterHandle filterCallback, FilterParamIndexBase index, Object filterForValue, ArrayDeque<EventTypeIndexBuilderIndexLookupablePair> treePathInfo, FilterServiceGranularLockFactory lockFactory) {
        boolean added;
        EventEvaluator eventEvaluator;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".addToIndex (" + Thread.currentThread().getId() + ") Adding to index " + index.toString() + "  expressionValue=" + filterForValue);
        }
        index.getReadWriteLock().readLock().lock();
        try {
            eventEvaluator = index.get(filterForValue);
            if (eventEvaluator != null && (added = IndexTreeBuilder.addToEvaluator(remainingParameters, filterCallback, eventEvaluator, treePathInfo, lockFactory))) {
                return;
            }
        }
        finally {
            index.getReadWriteLock().readLock().unlock();
        }
        index.getReadWriteLock().writeLock().lock();
        try {
            eventEvaluator = index.get(filterForValue);
            if (eventEvaluator != null) {
                added = IndexTreeBuilder.addToEvaluator(remainingParameters, filterCallback, eventEvaluator, treePathInfo, lockFactory);
                if (added) {
                    return;
                }
                FilterParamIndexBase nextIndex = (FilterParamIndexBase)eventEvaluator;
                FilterHandleSetNode newNode = new FilterHandleSetNode(lockFactory.obtainNew());
                newNode.add(nextIndex);
                index.remove(filterForValue);
                index.put(filterForValue, newNode);
                IndexTreeBuilder.addToNode(remainingParameters, filterCallback, newNode, treePathInfo, lockFactory);
                return;
            }
            if (remainingParameters.isEmpty()) {
                FilterHandleSetNode node = new FilterHandleSetNode(lockFactory.obtainNew());
                IndexTreeBuilder.addToNode(remainingParameters, filterCallback, node, treePathInfo, lockFactory);
                index.put(filterForValue, node);
                return;
            }
            FilterValueSetParam parameterPickedForIndex = remainingParameters.removeFirst();
            FilterParamIndexBase nextIndex = IndexFactory.createIndex(parameterPickedForIndex.getLookupable(), lockFactory, parameterPickedForIndex.getFilterOperator());
            index.put(filterForValue, nextIndex);
            treePathInfo.add(new EventTypeIndexBuilderIndexLookupablePair(nextIndex, parameterPickedForIndex.getFilterForValue()));
            IndexTreeBuilder.addToIndex(remainingParameters, filterCallback, nextIndex, parameterPickedForIndex.getFilterForValue(), treePathInfo, lockFactory);
        }
        finally {
            index.getReadWriteLock().writeLock().unlock();
        }
    }

    private static boolean addToEvaluator(ArrayDeque<FilterValueSetParam> remainingParameters, FilterHandle filterCallback, EventEvaluator eventEvaluator, ArrayDeque<EventTypeIndexBuilderIndexLookupablePair> treePathInfo, FilterServiceGranularLockFactory lockFactory) {
        if (eventEvaluator instanceof FilterHandleSetNode) {
            FilterHandleSetNode node = (FilterHandleSetNode)eventEvaluator;
            IndexTreeBuilder.addToNode(remainingParameters, filterCallback, node, treePathInfo, lockFactory);
            return true;
        }
        FilterParamIndexBase nextIndex = (FilterParamIndexBase)eventEvaluator;
        FilterValueSetParam parameter = IndexHelper.findParameter(remainingParameters, nextIndex);
        if (parameter != null) {
            remainingParameters.remove(parameter);
            treePathInfo.add(new EventTypeIndexBuilderIndexLookupablePair(nextIndex, parameter.getFilterForValue()));
            IndexTreeBuilder.addToIndex(remainingParameters, filterCallback, nextIndex, parameter.getFilterForValue(), treePathInfo, lockFactory);
            return true;
        }
        return false;
    }

    private static String printRemainingParameters(ArrayDeque<FilterValueSetParam> remainingParameters) {
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        for (FilterValueSetParam parameter : remainingParameters) {
            buffer.append("  param(").append(count).append(')');
            buffer.append(" property=").append(parameter.getLookupable());
            buffer.append(" operator=").append((Object)parameter.getFilterOperator());
            buffer.append(" value=").append(parameter.getFilterForValue());
            ++count;
        }
        return buffer.toString();
    }

    private static ArrayDeque<EventTypeIndexBuilderIndexLookupablePair>[] allocateTreePath(int size) {
        return new ArrayDeque[size];
    }
}

