/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filterspec;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.filterspec.FilterOperator;
import com.espertech.esper.filterspec.FilterSpecParam;
import com.espertech.esper.filterspec.MatchedEventMap;
import com.espertech.esper.util.SimpleNumberCoercer;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterSpecParamEventProp
extends FilterSpecParam {
    private static final Logger log = LoggerFactory.getLogger(FilterSpecParamEventProp.class);
    private final String resultEventAsName;
    private final String resultEventProperty;
    private final boolean isMustCoerce;
    private final transient SimpleNumberCoercer numberCoercer;
    private final Class coercionType;
    private final String statementName;
    private static final long serialVersionUID = 7839598101507253516L;

    public FilterSpecParamEventProp(ExprFilterSpecLookupable lookupable, FilterOperator filterOperator, String resultEventAsName, String resultEventProperty, boolean isMustCoerce, SimpleNumberCoercer numberCoercer, Class coercionType, String statementName) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        this.resultEventAsName = resultEventAsName;
        this.resultEventProperty = resultEventProperty;
        this.isMustCoerce = isMustCoerce;
        this.numberCoercer = numberCoercer;
        this.coercionType = coercionType;
        this.statementName = statementName;
        if (filterOperator.isRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to event property filter parameter");
        }
    }

    public boolean isMustCoerce() {
        return this.isMustCoerce;
    }

    public Class getCoercionType() {
        return this.coercionType;
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    @Override
    public Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext, EngineImportService engineImportService, Annotation[] annotations) {
        EventBean theEvent = matchedEvents.getMatchingEventByTag(this.resultEventAsName);
        Object value = null;
        if (theEvent == null) {
            if (log.isDebugEnabled()) {
                log.debug("Matching events for tag '" + this.resultEventAsName + "' returned a null result, using null value in filter criteria, for statement '" + this.statementName + "'");
            }
        } else {
            value = theEvent.get(this.resultEventProperty);
        }
        if (this.isMustCoerce) {
            value = this.numberCoercer.coerceBoxed((Number)value);
        }
        return value;
    }

    @Override
    public final String toString() {
        return super.toString() + " resultEventAsName=" + this.resultEventAsName + " resultEventProperty=" + this.resultEventProperty;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamEventProp)) {
            return false;
        }
        FilterSpecParamEventProp other = (FilterSpecParamEventProp)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.resultEventAsName.equals(other.resultEventAsName) && this.resultEventProperty.equals(other.resultEventProperty);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.resultEventProperty.hashCode();
        return result;
    }
}

