/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filterspec.MatchedEventMap;
import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.EvalEveryStateNode;
import com.espertech.esper.pattern.EvalEveryStateSpawnEvaluator;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.PatternConsumptionUtil;
import com.espertech.esper.pattern.PatternExpressionUtil;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalEveryDistinctStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalEveryDistinctNode everyDistinctNode;
    protected final Map<EvalStateNode, Set<Object>> spawnedNodes;
    protected MatchedEventMap beginState;
    private static final Logger log = LoggerFactory.getLogger(EvalEveryStateNode.class);

    public EvalEveryDistinctStateNode(Evaluator parentNode, EvalEveryDistinctNode everyDistinctNode) {
        super(parentNode);
        this.everyDistinctNode = everyDistinctNode;
        this.spawnedNodes = new LinkedHashMap<EvalStateNode, Set<Object>>();
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.beginState)) {
            this.quit();
            this.getParentEvaluator().evaluateFalse(this, true);
        } else {
            PatternConsumptionUtil.childNodeRemoveMatches(matchEvent, this.spawnedNodes.keySet());
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.everyDistinctNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        this.beginState = beginState.shallowCopy();
        EvalStateNode childState = this.everyDistinctNode.getChildNode().newState(this, null, 0L);
        this.spawnedNodes.put(childState, new HashSet());
        if (this.spawnedNodes.size() != 1) {
            throw new IllegalStateException("EVERY state node is expected to have single child state node");
        }
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyDistinctNode.getContext().getPatternContext().getStatementName());
        childState.setParentEvaluator(spawnEvaluator);
        childState.start(beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            childState.quit();
        } else {
            childState.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        fromNode.quit();
        this.spawnedNodes.remove(fromNode);
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyDistinctNode.getContext().getPatternContext().getStatementName());
        EvalStateNode spawned = this.everyDistinctNode.getChildNode().newState(spawnEvaluator, null, 0L);
        spawned.start(this.beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            spawned.quit();
        } else {
            this.spawnedNodes.put(spawned, new HashSet());
            spawned.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        Object matchEventKey = PatternExpressionUtil.getKeys(matchEvent, this.everyDistinctNode.getFactoryNode().getConvertor(), this.everyDistinctNode.getFactoryNode().getDistinctExpressionsArray(), this.everyDistinctNode.getContext().getAgentInstanceContext());
        boolean haveSeenThis = false;
        Set<Object> keysFromNode = this.spawnedNodes.get(fromNode);
        if (keysFromNode != null) {
            if (keysFromNode.contains(matchEventKey)) {
                haveSeenThis = true;
            } else {
                keysFromNode.add(matchEventKey);
            }
        }
        if (isQuitted) {
            this.spawnedNodes.remove(fromNode);
        }
        if (!fromNode.isFilterStateNode()) {
            EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyDistinctNode.getContext().getPatternContext().getStatementName());
            EvalStateNode spawned = this.everyDistinctNode.getChildNode().newState(spawnEvaluator, null, 0L);
            spawned.start(this.beginState);
            if (spawnEvaluator.isEvaluatedTrue()) {
                spawned.quit();
            } else {
                HashSet<Object> keyset = new HashSet<Object>();
                if (keysFromNode != null) {
                    keyset.addAll(keysFromNode);
                }
                this.spawnedNodes.put(spawned, keyset);
                spawned.setParentEvaluator(this);
            }
        }
        if (!haveSeenThis) {
            this.getParentEvaluator().evaluateTrue(matchEvent, this, false, optionalTriggeringEvent);
        }
    }

    @Override
    public final void quit() {
        for (EvalStateNode child : this.spawnedNodes.keySet()) {
            child.quit();
        }
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitEveryDistinct(this.everyDistinctNode.getFactoryNode(), this, this.beginState, this.spawnedNodes.values());
        for (EvalStateNode spawnedNode : this.spawnedNodes.keySet()) {
            spawnedNode.accept(visitor);
        }
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalEveryStateNode spawnedChildren=" + this.spawnedNodes.size();
    }
}

