/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filterspec.MatchedEventMap;
import com.espertech.esper.pattern.EvalMatchUntilFactoryNode;
import com.espertech.esper.pattern.PatternAgentInstanceContext;

public class EvalMatchUntilStateBounds {
    private final Integer lowerbounds;
    private final Integer upperbounds;

    public EvalMatchUntilStateBounds(Integer lowerbounds, Integer upperbounds) {
        this.lowerbounds = lowerbounds;
        this.upperbounds = upperbounds;
    }

    public Integer getLowerbounds() {
        return this.lowerbounds;
    }

    public Integer getUpperbounds() {
        return this.upperbounds;
    }

    public static EvalMatchUntilStateBounds initBounds(EvalMatchUntilFactoryNode factoryNode, MatchedEventMap beginState, PatternAgentInstanceContext context) {
        Integer lowerbounds = null;
        Integer upperbounds = null;
        EventBean[] eventsPerStream = factoryNode.getConvertor().convert(beginState);
        if (factoryNode.getSingleBound() != null) {
            Integer bounds;
            lowerbounds = bounds = (Integer)factoryNode.getSingleBound().getForge().getExprEvaluator().evaluate(eventsPerStream, true, context.getAgentInstanceContext());
            upperbounds = bounds;
        } else {
            if (factoryNode.getLowerBounds() != null) {
                lowerbounds = (Integer)factoryNode.getLowerBounds().getForge().getExprEvaluator().evaluate(eventsPerStream, true, context.getAgentInstanceContext());
            }
            if (factoryNode.getUpperBounds() != null) {
                upperbounds = (Integer)factoryNode.getUpperBounds().getForge().getExprEvaluator().evaluate(eventsPerStream, true, context.getAgentInstanceContext());
            }
            if (upperbounds != null && lowerbounds != null && upperbounds < lowerbounds) {
                Integer lbounds = lowerbounds;
                lowerbounds = upperbounds;
                upperbounds = lbounds;
            }
        }
        return new EvalMatchUntilStateBounds(lowerbounds, upperbounds);
    }
}

