/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.observer;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.util.TimePeriod;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNamedParameterNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.filterspec.MatchedEventMap;
import com.espertech.esper.filterspec.MatchedEventMapImpl;
import com.espertech.esper.pattern.EvalStateNodeNumber;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternExpressionUtil;
import com.espertech.esper.pattern.observer.EventObserver;
import com.espertech.esper.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.pattern.observer.ObserverFactory;
import com.espertech.esper.pattern.observer.ObserverParameterException;
import com.espertech.esper.pattern.observer.TimerScheduleISO8601Parser;
import com.espertech.esper.pattern.observer.TimerScheduleObserver;
import com.espertech.esper.pattern.observer.TimerScheduleSpec;
import com.espertech.esper.schedule.ScheduleParameterException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class TimerScheduleObserverFactory
implements ObserverFactory,
Serializable {
    private static final String NAME_OBSERVER = "Timer-schedule observer";
    private static final String ISO_NAME = "iso";
    private static final String REPETITIONS_NAME = "repetitions";
    private static final String DATE_NAME = "date";
    private static final String PERIOD_NAME = "period";
    private static final String[] NAMED_PARAMETERS = new String[]{"iso", "repetitions", "date", "period"};
    private static final long serialVersionUID = 6180792299082096772L;
    protected transient TimerScheduleSpecCompute scheduleComputer;
    protected transient MatchedEventConvertor convertor;
    protected TimerScheduleSpec spec;

    @Override
    public void setObserverParameters(List<ExprNode> parameters, MatchedEventConvertor convertor, ExprValidationContext validationContext) throws ObserverParameterException {
        boolean allConstantResult;
        Map<String, ExprNamedParameterNode> namedExpressions;
        this.convertor = convertor;
        try {
            namedExpressions = ExprNodeUtilityRich.getNamedExpressionsHandleDups(parameters);
            ExprNodeUtilityRich.validateNamed(namedExpressions, NAMED_PARAMETERS);
        }
        catch (ExprValidationException e) {
            throw new ObserverParameterException(e.getMessage(), e);
        }
        ExprNamedParameterNode isoStringExpr = namedExpressions.get(ISO_NAME);
        if (namedExpressions.size() == 1 && isoStringExpr != null) {
            try {
                allConstantResult = ExprNodeUtilityRich.validateNamedExpectType(isoStringExpr, new Class[]{String.class});
            }
            catch (ExprValidationException ex) {
                throw new ObserverParameterException(ex.getMessage(), ex);
            }
            this.scheduleComputer = new TimerScheduleSpecComputeISOString(isoStringExpr.getChildNodes()[0]);
        } else {
            if (isoStringExpr != null) {
                throw new ObserverParameterException("The 'iso' parameter is exclusive of other parameters");
            }
            if (namedExpressions.size() == 0) {
                throw new ObserverParameterException("No parameters provided");
            }
            allConstantResult = true;
            ExprNamedParameterNode dateNamedNode = namedExpressions.get(DATE_NAME);
            ExprNamedParameterNode repetitionsNamedNode = namedExpressions.get(REPETITIONS_NAME);
            ExprNamedParameterNode periodNamedNode = namedExpressions.get(PERIOD_NAME);
            if (dateNamedNode == null && periodNamedNode == null) {
                throw new ObserverParameterException("Either the date or period parameter is required");
            }
            try {
                if (dateNamedNode != null) {
                    allConstantResult = ExprNodeUtilityRich.validateNamedExpectType(dateNamedNode, new Class[]{String.class, Calendar.class, Date.class, Long.class, LocalDateTime.class, ZonedDateTime.class});
                }
                if (repetitionsNamedNode != null) {
                    allConstantResult &= ExprNodeUtilityRich.validateNamedExpectType(repetitionsNamedNode, new Class[]{Integer.class, Long.class});
                }
                if (periodNamedNode != null) {
                    allConstantResult &= ExprNodeUtilityRich.validateNamedExpectType(periodNamedNode, new Class[]{TimePeriod.class});
                }
            }
            catch (ExprValidationException ex) {
                throw new ObserverParameterException(ex.getMessage(), ex);
            }
            ExprNode dateNode = dateNamedNode == null ? null : dateNamedNode.getChildNodes()[0];
            ExprNode repetitionsNode = repetitionsNamedNode == null ? null : repetitionsNamedNode.getChildNodes()[0];
            ExprTimePeriod periodNode = periodNamedNode == null ? null : (ExprTimePeriod)periodNamedNode.getChildNodes()[0];
            this.scheduleComputer = new TimerScheduleSpecComputeFromExpr(dateNode, repetitionsNode, periodNode);
        }
        if (allConstantResult) {
            try {
                this.spec = this.scheduleComputer.compute(convertor, new MatchedEventMapImpl(convertor.getMatchedEventMapMeta()), null, validationContext.getEngineImportService().getTimeZone(), validationContext.getEngineImportService().getTimeAbacus());
            }
            catch (ScheduleParameterException ex) {
                throw new ObserverParameterException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public EventObserver makeObserver(PatternAgentInstanceContext context, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator, EvalStateNodeNumber stateNodeId, Object observerState, boolean isFilterChildNonQuitting) {
        return new TimerScheduleObserver(this.computeSpecDynamic(beginState, context), beginState, observerEventEvaluator, isFilterChildNonQuitting);
    }

    @Override
    public boolean isNonRestarting() {
        return true;
    }

    public TimerScheduleSpec computeSpecDynamic(MatchedEventMap beginState, PatternAgentInstanceContext context) {
        if (this.spec != null) {
            return this.spec;
        }
        try {
            return this.scheduleComputer.compute(this.convertor, beginState, context.getAgentInstanceContext(), context.getStatementContext().getEngineImportService().getTimeZone(), context.getStatementContext().getEngineImportService().getTimeAbacus());
        }
        catch (ScheduleParameterException e) {
            throw new EPException("Error computing iso8601 schedule specification: " + e.getMessage(), e);
        }
    }

    private static class TimerScheduleSpecComputeFromExpr
    implements TimerScheduleSpecCompute {
        private final ExprNode dateNode;
        private final ExprNode repetitionsNode;
        private final ExprTimePeriod periodNode;

        private TimerScheduleSpecComputeFromExpr(ExprNode dateNode, ExprNode repetitionsNode, ExprTimePeriod periodNode) {
            this.dateNode = dateNode;
            this.repetitionsNode = repetitionsNode;
            this.periodNode = periodNode;
        }

        @Override
        public TimerScheduleSpec compute(MatchedEventConvertor convertor, MatchedEventMap beginState, ExprEvaluatorContext exprEvaluatorContext, TimeZone timeZone, TimeAbacus timeAbacus) throws ScheduleParameterException {
            Object param;
            Calendar optionalDate = null;
            Long optionalRemainder = null;
            if (this.dateNode != null) {
                Object param2 = PatternExpressionUtil.evaluate(TimerScheduleObserverFactory.NAME_OBSERVER, beginState, this.dateNode, convertor, exprEvaluatorContext);
                if (param2 instanceof String) {
                    optionalDate = TimerScheduleISO8601Parser.parseDate((String)param2);
                } else if (param2 instanceof Number) {
                    long msec = ((Number)param2).longValue();
                    optionalDate = Calendar.getInstance(timeZone);
                    optionalRemainder = timeAbacus.calendarSet(msec, optionalDate);
                } else if (param2 instanceof Calendar) {
                    optionalDate = (Calendar)param2;
                } else if (param2 instanceof Date) {
                    optionalDate = Calendar.getInstance(timeZone);
                    optionalDate.setTimeInMillis(((Date)param2).getTime());
                } else if (param2 instanceof LocalDateTime) {
                    LocalDateTime ldt = (LocalDateTime)param2;
                    Date d = Date.from(ldt.atZone(timeZone.toZoneId()).toInstant());
                    optionalDate = Calendar.getInstance(timeZone);
                    optionalDate.setTimeInMillis(d.getTime());
                } else if (param2 instanceof ZonedDateTime) {
                    ZonedDateTime zdt = (ZonedDateTime)param2;
                    optionalDate = GregorianCalendar.from(zdt);
                } else {
                    if (param2 == null) {
                        throw new EPException("Null date-time value returned from " + ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(this.dateNode));
                    }
                    throw new EPException("Unrecognized date-time value " + param2.getClass());
                }
            }
            TimePeriod optionalTimePeriod = null;
            if (this.periodNode != null) {
                Object param3 = PatternExpressionUtil.evaluateTimePeriod(TimerScheduleObserverFactory.NAME_OBSERVER, beginState, this.periodNode, convertor, exprEvaluatorContext);
                optionalTimePeriod = (TimePeriod)param3;
            }
            Long optionalRepeatCount = null;
            if (this.repetitionsNode != null && (param = PatternExpressionUtil.evaluate(TimerScheduleObserverFactory.NAME_OBSERVER, beginState, this.repetitionsNode, convertor, exprEvaluatorContext)) != null) {
                optionalRepeatCount = ((Number)param).longValue();
            }
            if (optionalDate == null && optionalTimePeriod == null) {
                throw new EPException("Required date or time period are both null for Timer-schedule observer");
            }
            return new TimerScheduleSpec(optionalDate, optionalRemainder, optionalRepeatCount, optionalTimePeriod);
        }
    }

    private static class TimerScheduleSpecComputeISOString
    implements TimerScheduleSpecCompute {
        private final ExprNode parameter;

        private TimerScheduleSpecComputeISOString(ExprNode parameter) {
            this.parameter = parameter;
        }

        @Override
        public TimerScheduleSpec compute(MatchedEventConvertor convertor, MatchedEventMap beginState, ExprEvaluatorContext exprEvaluatorContext, TimeZone timeZone, TimeAbacus timeAbacus) throws ScheduleParameterException {
            Object param = PatternExpressionUtil.evaluate(TimerScheduleObserverFactory.NAME_OBSERVER, beginState, this.parameter, convertor, exprEvaluatorContext);
            String iso = (String)param;
            if (iso == null) {
                throw new ScheduleParameterException("Received null parameter value");
            }
            return TimerScheduleISO8601Parser.parse(iso);
        }
    }

    private static interface TimerScheduleSpecCompute {
        public TimerScheduleSpec compute(MatchedEventConvertor var1, MatchedEventMap var2, ExprEvaluatorContext var3, TimeZone var4, TimeAbacus var5) throws ScheduleParameterException;
    }
}

