/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.type;

public class XYWHRectangle {
    protected final double x;
    protected final double y;
    protected final double w;
    protected final double h;

    public XYWHRectangle(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public boolean coordinateEquals(double otherX, double otherY, double otherWidth, double otherHeight) {
        return this.x == otherX && this.y == otherY && this.w == otherWidth && this.h == otherHeight;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getW() {
        return this.w;
    }

    public double getH() {
        return this.h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XYWHRectangle that = (XYWHRectangle)o;
        if (Double.compare(that.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(that.y, this.y) != 0) {
            return false;
        }
        if (Double.compare(that.w, this.w) != 0) {
            return false;
        }
        return Double.compare(that.h, this.h) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.w);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.h);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

