/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectInputStreamWithTCCL
extends ObjectInputStream {
    private static final Logger log = LoggerFactory.getLogger(ObjectInputStreamWithTCCL.class);

    public ObjectInputStreamWithTCCL(InputStream input) throws IOException {
        super(input);
    }

    public ObjectInputStreamWithTCCL() throws IOException, SecurityException {
    }

    public Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("Resolving class " + desc.getName() + " id " + desc.getSerialVersionUID() + " classloader " + Thread.currentThread().getContextClassLoader().getClass());
        }
        ClassLoader currentTccl = null;
        try {
            currentTccl = Thread.currentThread().getContextClassLoader();
            if (currentTccl != null) {
                return currentTccl.loadClass(desc.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.resolveClass(desc);
    }
}

