/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.streamtype.StreamTypeService;
import com.espertech.esper.epl.core.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.visitor.ExprNodeSummaryVisitor;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewParameterException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ViewFactorySupport
implements ViewFactory {
    private static final Logger log = LoggerFactory.getLogger(ViewFactorySupport.class);

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        return false;
    }

    public static Object validateAndEvaluate(String viewName, StatementContext statementContext, ExprNode expression) throws ViewParameterException {
        return ViewFactorySupport.validateAndEvaluateExpr(viewName, statementContext, expression, new StreamTypeServiceImpl(statementContext.getEngineURI(), false), 0);
    }

    public static ExprNode[] validate(String viewName, StatementContext statementContext, List<ExprNode> expressions) throws ViewParameterException {
        ExprNode[] results = new ExprNode[expressions.size()];
        int expressionNumber = 0;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(statementContext.getEngineURI(), false);
        for (ExprNode expr : expressions) {
            results[expressionNumber] = ViewFactorySupport.validateExpr(viewName, statementContext, expr, streamTypeService, expressionNumber);
            ++expressionNumber;
        }
        return results;
    }

    public static ExprNode[] validate(String viewName, EventType eventType, StatementContext statementContext, List<ExprNode> expressions, boolean allowConstantResult) throws ViewParameterException {
        ArrayList<ExprNode> results = new ArrayList<ExprNode>();
        int expressionNumber = 0;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(eventType, null, false, statementContext.getEngineURI());
        for (ExprNode expr : expressions) {
            ExprNode validated = ViewFactorySupport.validateExpr(viewName, statementContext, expr, streamTypeService, expressionNumber);
            results.add(validated);
            if (!allowConstantResult && validated.isConstantResult()) {
                String message = "Invalid view parameter expression " + expressionNumber + ViewFactorySupport.getViewDesc(viewName) + ", the expression returns a constant result value, are you sure?";
                log.error(message);
                throw new ViewParameterException(message);
            }
            ++expressionNumber;
        }
        return results.toArray(new ExprNode[results.size()]);
    }

    public static void assertReturnsNonConstant(String viewName, ExprNode expression, int index) throws ViewParameterException {
        if (expression.isConstantResult()) {
            String message = "Invalid view parameter expression " + index + ViewFactorySupport.getViewDesc(viewName) + ", the expression returns a constant result value, are you sure?";
            log.error(message);
            throw new ViewParameterException(message);
        }
    }

    public static Object evaluateAssertNoProperties(String viewName, ExprNode expression, int index, ExprEvaluatorContext exprEvaluatorContext) throws ViewParameterException {
        ViewFactorySupport.validateNoProperties(viewName, expression, index);
        return expression.getForge().getExprEvaluator().evaluate(null, false, exprEvaluatorContext);
    }

    public static void validateNoProperties(String viewName, ExprNode expression, int index) throws ViewParameterException {
        ExprNodeSummaryVisitor visitor = new ExprNodeSummaryVisitor();
        expression.accept(visitor);
        if (!visitor.isPlain()) {
            String message = "Invalid view parameter expression " + index + ViewFactorySupport.getViewDesc(viewName) + ", " + visitor.getMessage() + " are not allowed within the expression";
            throw new ViewParameterException(message);
        }
    }

    public static Object validateAndEvaluateExpr(String viewName, StatementContext statementContext, ExprNode expression, StreamTypeService streamTypeService, int expressionNumber) throws ViewParameterException {
        ExprNode validated = ViewFactorySupport.validateExpr(viewName, statementContext, expression, streamTypeService, expressionNumber);
        try {
            return validated.getForge().getExprEvaluator().evaluate(null, true, new ExprEvaluatorContextStatement(statementContext, false));
        }
        catch (RuntimeException ex) {
            String message = "Failed to evaluate parameter expression " + expressionNumber + ViewFactorySupport.getViewDesc(viewName);
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error(message, (Throwable)ex);
            throw new ViewParameterException(message, ex);
        }
    }

    public static Object evaluate(ExprEvaluator evaluator, int expressionNumber, String viewName, StatementContext statementContext) throws ViewParameterException {
        try {
            return evaluator.evaluate(null, true, new ExprEvaluatorContextStatement(statementContext, false));
        }
        catch (RuntimeException ex) {
            String message = "Failed to evaluate parameter expression " + expressionNumber + ViewFactorySupport.getViewDesc(viewName);
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error(message, (Throwable)ex);
            throw new ViewParameterException(message, ex);
        }
    }

    public static ExprNode validateExpr(String viewName, StatementContext statementContext, ExprNode expression, StreamTypeService streamTypeService, int expressionNumber) throws ViewParameterException {
        ExprNode validated;
        try {
            ExprEvaluatorContextStatement exprEvaluatorContext = new ExprEvaluatorContextStatement(statementContext, false);
            ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, statementContext.getEngineImportService(), statementContext.getStatementExtensionServicesContext(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext.getTableService(), exprEvaluatorContext, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, false, false, null, false);
            validated = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.VIEWPARAMETER, expression, validationContext);
        }
        catch (ExprValidationException ex) {
            String message = "Invalid parameter expression " + expressionNumber + ViewFactorySupport.getViewDesc(viewName);
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error(message, (Throwable)ex);
            throw new ViewParameterException(message, ex);
        }
        return validated;
    }

    private static String getViewDesc(String viewName) {
        return " for " + viewName + " view";
    }

    public static ExprEvaluator validateSizeSingleParam(String viewName, ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate(viewName, viewFactoryContext.getStatementContext(), expressionParameters);
        if (validated.length != 1) {
            throw new ViewParameterException(ViewFactorySupport.getViewParamMessage(viewName));
        }
        return ViewFactorySupport.validateSizeParam(viewName, viewFactoryContext.getStatementContext(), validated[0], 0);
    }

    public static ExprEvaluator validateSizeParam(String viewName, StatementContext statementContext, ExprNode sizeNode, int expressionNumber) throws ViewParameterException {
        Number size;
        ExprEvaluator sizeEvaluator = sizeNode.getForge().getExprEvaluator();
        Class returnType = JavaClassHelper.getBoxedType(sizeNode.getForge().getEvaluationType());
        if (!JavaClassHelper.isNumeric(returnType) || JavaClassHelper.isFloatingPointClass(returnType) || returnType == Long.class) {
            throw new ViewParameterException(ViewFactorySupport.getViewParamMessage(viewName));
        }
        if (sizeNode.isConstantResult() && !ViewFactorySupport.validateSize(size = (Number)ViewFactorySupport.evaluate(sizeEvaluator, expressionNumber, viewName, statementContext))) {
            throw new ViewParameterException(ViewFactorySupport.getSizeValidationMsg(viewName, size));
        }
        return sizeEvaluator;
    }

    public static int evaluateSizeParam(String viewName, ExprEvaluator sizeEvaluator, AgentInstanceContext context) {
        Number size = (Number)sizeEvaluator.evaluate(null, true, context);
        if (!ViewFactorySupport.validateSize(size)) {
            throw new EPException(ViewFactorySupport.getSizeValidationMsg(viewName, size));
        }
        return size.intValue();
    }

    private static boolean validateSize(Number size) {
        return size != null && size.intValue() > 0;
    }

    private static String getViewParamMessage(String viewName) {
        return viewName + " view requires a single integer-type parameter";
    }

    private static String getSizeValidationMsg(String viewName, Number size) {
        return viewName + " view requires a positive integer for size but received " + size;
    }

    public static void validateNoParameters(String viewName, List<ExprNode> expressionParameters) throws ViewParameterException {
        if (!expressionParameters.isEmpty()) {
            String errorMessage = viewName + " view requires an empty parameter list";
            throw new ViewParameterException(errorMessage);
        }
    }
}

