/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.HashableMultiKey;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.ext.IStreamSortRankRandomAccess;
import com.espertech.esper.view.ext.SortWindowIterator;
import com.espertech.esper.view.ext.SortWindowViewFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class SortWindowView
extends ViewSupport
implements DataWindowView {
    private final SortWindowViewFactory sortWindowViewFactory;
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final int sortWindowSize;
    private final IStreamSortRankRandomAccess optionalSortedRandomAccess;
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    protected TreeMap<Object, Object> sortedEvents;
    protected int eventCount;

    public SortWindowView(SortWindowViewFactory sortWindowViewFactory, int sortWindowSize, IStreamSortRankRandomAccess optionalSortedRandomAccess, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.sortWindowViewFactory = sortWindowViewFactory;
        this.sortWindowSize = sortWindowSize;
        this.optionalSortedRandomAccess = optionalSortedRandomAccess;
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.sortedEvents = new TreeMap(sortWindowViewFactory.comparator);
    }

    protected final ExprNode[] getSortCriteriaExpressions() {
        return this.sortWindowViewFactory.sortCriteriaExpressions;
    }

    protected final boolean[] getIsDescendingValues() {
        return this.sortWindowViewFactory.isDescendingValues;
    }

    protected final int getSortWindowSize() {
        return this.sortWindowSize;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        Object sortValues;
        int i;
        OneEventCollection removedEvents = null;
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                EventBean oldDataItem = oldData[i];
                sortValues = this.getSortValues(oldDataItem);
                boolean result = CollectionUtil.removeEventByKeyLazyListMap(sortValues, oldDataItem, this.sortedEvents);
                if (!result) continue;
                --this.eventCount;
                if (removedEvents == null) {
                    removedEvents = new OneEventCollection();
                }
                removedEvents.add(oldDataItem);
                this.internalHandleRemoved(sortValues, oldDataItem);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                EventBean newDataItem = newData[i];
                sortValues = this.getSortValues(newDataItem);
                CollectionUtil.addEventByKeyLazyListMapFront(sortValues, newDataItem, this.sortedEvents);
                ++this.eventCount;
                this.internalHandleAdd(sortValues, newDataItem);
            }
        }
        if (this.eventCount > this.sortWindowSize) {
            int removeCount = this.eventCount - this.sortWindowSize;
            for (int i2 = 0; i2 < removeCount; ++i2) {
                Object lastKey = this.sortedEvents.lastKey();
                Object lastEntry = this.sortedEvents.get(lastKey);
                if (lastEntry instanceof List) {
                    List events = (List)lastEntry;
                    EventBean theEvent = (EventBean)events.remove(events.size() - 1);
                    --this.eventCount;
                    if (events.isEmpty()) {
                        this.sortedEvents.remove(lastKey);
                    }
                    if (removedEvents == null) {
                        removedEvents = new OneEventCollection();
                    }
                    removedEvents.add(theEvent);
                    this.internalHandleRemoved(lastKey, theEvent);
                    continue;
                }
                EventBean theEvent = (EventBean)lastEntry;
                --this.eventCount;
                this.sortedEvents.remove(lastKey);
                if (removedEvents == null) {
                    removedEvents = new OneEventCollection();
                }
                removedEvents.add(theEvent);
                this.internalHandleRemoved(lastKey, theEvent);
            }
        }
        if (this.optionalSortedRandomAccess != null) {
            this.optionalSortedRandomAccess.refresh(this.sortedEvents, this.eventCount, this.sortWindowSize);
        }
        if (this.hasViews()) {
            EventBean[] expiredArr = null;
            if (removedEvents != null) {
                expiredArr = removedEvents.toArray();
            }
            this.updateChildren(newData, expiredArr);
        }
    }

    public void internalHandleAdd(Object sortValues, EventBean newDataItem) {
    }

    public void internalHandleRemoved(Object sortValues, EventBean oldDataItem) {
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SortWindowIterator(this.sortedEvents);
    }

    public final String toString() {
        return this.getClass().getName() + " sortFieldName=" + Arrays.toString(this.sortWindowViewFactory.sortCriteriaExpressions) + " isDescending=" + Arrays.toString(this.sortWindowViewFactory.isDescendingValues) + " sortWindowSize=" + this.sortWindowSize;
    }

    protected Object getSortValues(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        if (this.sortWindowViewFactory.sortCriteriaExpressions.length == 1) {
            return this.sortWindowViewFactory.sortCriteriaEvaluators[0].evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        }
        Object[] result = new Object[this.sortWindowViewFactory.sortCriteriaExpressions.length];
        int count = 0;
        for (ExprEvaluator expr : this.sortWindowViewFactory.sortCriteriaEvaluators) {
            result[count++] = expr.evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        }
        return new HashableMultiKey(result);
    }

    public boolean isEmpty() {
        if (this.sortedEvents == null) {
            return true;
        }
        return this.sortedEvents.isEmpty();
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.sortedEvents, false, this.sortWindowViewFactory.getViewName(), this.eventCount, null);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.sortWindowViewFactory;
    }
}

