/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import com.espertech.esper.view.std.SizeView;
import java.util.List;

public class SizeViewFactory
implements ViewFactory {
    protected static final String NAME = "Size";
    private List<ExprNode> viewParameters;
    private int streamNumber;
    protected StatViewAdditionalProps additionalProps;
    protected EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
        this.streamNumber = viewFactoryContext.getStreamNum();
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate(this.getViewName(), parentEventType, statementContext, this.viewParameters, true);
        this.additionalProps = StatViewAdditionalProps.make(validated, 0, parentEventType, statementContext.getEngineImportService(), statementContext.getStatementName());
        this.eventType = SizeView.createEventType(statementContext, this.additionalProps, this.streamNumber);
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new SizeView(agentInstanceViewFactoryContext.getAgentInstanceContext(), this.eventType, this.additionalProps);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        if (!(view instanceof SizeView)) {
            return false;
        }
        return this.additionalProps == null;
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    public StatViewAdditionalProps getAdditionalProps() {
        return this.additionalProps;
    }
}

