/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stream;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.RefCountedMap;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.filter.FilterServiceEntry;
import com.espertech.esper.filterspec.FilterSpecCompiled;
import com.espertech.esper.filterspec.FilterValueSet;
import com.espertech.esper.view.EventStream;
import com.espertech.esper.view.ZeroDepthStreamIterable;
import com.espertech.esper.view.ZeroDepthStreamNoIterate;
import com.espertech.esper.view.stream.EventStreamProxy;
import com.espertech.esper.view.stream.StreamFactoryService;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.IdentityHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFactorySvcImpl
implements StreamFactoryService {
    private static final Logger log = LoggerFactory.getLogger(StreamFactorySvcImpl.class);
    private final IdentityHashMap<Object, StreamEntry> eventStreamsIdentity;
    private final RefCountedMap<FilterSpecCompiled, StreamEntry> eventStreamsRefCounted;
    private final String engineURI;
    private final boolean isReuseViews;

    public StreamFactorySvcImpl(String engineURI, boolean isReuseViews) {
        this.engineURI = engineURI;
        this.eventStreamsRefCounted = new RefCountedMap();
        this.eventStreamsIdentity = new IdentityHashMap();
        this.isReuseViews = isReuseViews;
    }

    @Override
    public void destroy() {
        this.eventStreamsRefCounted.clear();
        this.eventStreamsIdentity.clear();
    }

    @Override
    public Pair<EventStream, StatementAgentInstanceLock> createStream(final int statementId, final FilterSpecCompiled filterSpec, FilterService filterService, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle, boolean isJoin, final AgentInstanceContext agentInstanceContext, boolean hasOrderBy, boolean filterWithSameTypeSubselect, Annotation[] annotations, boolean stateless, final int streamNum, boolean isCanIterateUnbound) {
        EventStream inputStream;
        boolean forceNewStream;
        StreamEntry entry;
        if (log.isDebugEnabled()) {
            log.debug(".createStream hashCode=" + filterSpec.hashCode() + " filter=" + filterSpec);
        }
        if ((entry = (forceNewStream = isJoin || !this.isReuseViews || hasOrderBy || filterWithSameTypeSubselect || stateless) ? this.eventStreamsIdentity.get(filterSpec) : this.eventStreamsRefCounted.get(filterSpec)) != null) {
            if (forceNewStream) {
                throw new IllegalStateException("Filter spec object already found in collection");
            }
            log.debug(".createStream filter already found");
            this.eventStreamsRefCounted.reference(filterSpec);
            EventStream eventStream = EventStreamProxy.getAuditProxy(this.engineURI, epStatementAgentInstanceHandle.getStatementHandle().getStatementName(), annotations, filterSpec, entry.getEventStream());
            return new Pair<EventStream, StatementAgentInstanceLock>(eventStream, entry.getCallback().getAgentInstanceHandle().getStatementAgentInstanceLock());
        }
        EventType resultEventType = filterSpec.getResultEventType();
        EventStream zeroDepthStream = isCanIterateUnbound ? new ZeroDepthStreamIterable(resultEventType) : new ZeroDepthStreamNoIterate(resultEventType);
        final EventStream eventStream = inputStream = EventStreamProxy.getAuditProxy(this.engineURI, epStatementAgentInstanceHandle.getStatementHandle().getStatementName(), annotations, filterSpec, zeroDepthStream);
        FilterHandleCallback filterCallback = filterSpec.getOptionalPropertyEvaluator() != null ? new FilterHandleCallback(){

            @Override
            public int getStatementId() {
                return statementId;
            }

            @Override
            public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
                EventBean[] result = filterSpec.getOptionalPropertyEvaluator().getProperty(theEvent, agentInstanceContext);
                if (result == null) {
                    return;
                }
                eventStream.insert(result);
            }

            @Override
            public boolean isSubSelect() {
                return false;
            }
        } : new FilterHandleCallback(){

            @Override
            public int getStatementId() {
                return statementId;
            }

            @Override
            public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
                eventStream.insert(theEvent);
            }

            @Override
            public boolean isSubSelect() {
                return false;
            }
        };
        EPStatementHandleCallback handle = new EPStatementHandleCallback(epStatementAgentInstanceHandle, filterCallback);
        entry = new StreamEntry(eventStream, handle);
        if (forceNewStream) {
            this.eventStreamsIdentity.put(filterSpec, entry);
        } else {
            this.eventStreamsRefCounted.put(filterSpec, entry);
        }
        FilterValueSet filterValues = filterSpec.getValueSet(null, null, agentInstanceContext, agentInstanceContext.getEngineImportService(), agentInstanceContext.getAnnotations());
        FilterServiceEntry filterServiceEntry = filterService.add(filterValues, handle);
        entry.setFilterServiceEntry(filterServiceEntry);
        return new Pair<EventStream, Object>(inputStream, null);
    }

    @Override
    public void dropStream(FilterSpecCompiled filterSpec, FilterService filterService, boolean isJoin, boolean hasOrderBy, boolean filterWithSameTypeSubselect, boolean stateless) {
        boolean forceNewStream;
        boolean bl = forceNewStream = isJoin || !this.isReuseViews || hasOrderBy || filterWithSameTypeSubselect || stateless;
        if (forceNewStream) {
            StreamEntry entry = this.eventStreamsIdentity.get(filterSpec);
            if (entry == null) {
                throw new IllegalStateException("Filter spec object not in collection");
            }
            this.eventStreamsIdentity.remove(filterSpec);
            filterService.remove(entry.getCallback(), entry.getFilterServiceEntry());
        } else {
            StreamEntry entry = this.eventStreamsRefCounted.get(filterSpec);
            boolean isLast = this.eventStreamsRefCounted.dereference(filterSpec);
            if (isLast) {
                filterService.remove(entry.getCallback(), entry.getFilterServiceEntry());
            }
        }
    }

    private static final class StreamEntry {
        private final EventStream eventStream;
        private final EPStatementHandleCallback callback;
        private FilterServiceEntry filterServiceEntry;

        public StreamEntry(EventStream eventStream, EPStatementHandleCallback callback) {
            this.eventStream = eventStream;
            this.callback = callback;
        }

        public EventStream getEventStream() {
            return this.eventStream;
        }

        public EPStatementHandleCallback getCallback() {
            return this.callback;
        }

        public void setFilterServiceEntry(FilterServiceEntry filterServiceEntry) {
            this.filterServiceEntry = filterServiceEntry;
        }

        public FilterServiceEntry getFilterServiceEntry() {
            return this.filterServiceEntry;
        }
    }
}

