/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.view.DataWindowBatchingViewFactory;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewFactoryTimePeriodHelper;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexGetterImpl;
import com.espertech.esper.view.window.TimeBatchViewFactoryParams;
import com.espertech.esper.view.window.TimeLengthBatchView;
import java.util.List;

public class TimeLengthBatchViewFactory
extends TimeBatchViewFactoryParams
implements DataWindowViewFactory,
DataWindowViewWithPrevious,
DataWindowBatchingViewFactory {
    protected ExprEvaluator sizeEvaluator;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate(this.getViewName(), viewFactoryContext.getStatementContext(), expressionParameters);
        String errorMessage = this.getViewName() + " view requires a numeric or time period parameter as a time interval size, and an integer parameter as a maximal number-of-events, and an optional list of control keywords as a string parameter (please see the documentation)";
        if (validated.length != 2 && validated.length != 3) {
            throw new ViewParameterException(errorMessage);
        }
        this.timeDeltaComputationFactory = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDeltaFactory(this.getViewName(), viewFactoryContext.getStatementContext(), expressionParameters.get(0), errorMessage, 0);
        this.sizeEvaluator = ViewFactorySupport.validateSizeParam(this.getViewName(), viewFactoryContext.getStatementContext(), validated[1], 1);
        if (validated.length > 2) {
            Object keywords = ViewFactorySupport.evaluate(validated[2].getForge().getExprEvaluator(), 2, this.getViewName(), viewFactoryContext.getStatementContext());
            this.processKeywords(keywords, errorMessage);
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RelativeAccessByEventNIndexGetterImpl();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        ExprTimePeriodEvalDeltaConst timeDeltaComputation = this.timeDeltaComputationFactory.make(this.getViewName(), "view", agentInstanceViewFactoryContext.getAgentInstanceContext(), agentInstanceViewFactoryContext.getTimeAbacus());
        int size = ViewFactorySupport.evaluateSizeParam(this.getViewName(), this.sizeEvaluator, agentInstanceViewFactoryContext.getAgentInstanceContext());
        ViewUpdatedCollection viewUpdatedCollection = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprRelativeAccess(agentInstanceViewFactoryContext);
        return new TimeLengthBatchView(this, agentInstanceViewFactoryContext, timeDeltaComputation, size, this.isForceUpdate, this.isStartEager, viewUpdatedCollection);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        if (!(view instanceof TimeLengthBatchView)) {
            return false;
        }
        TimeLengthBatchView myView = (TimeLengthBatchView)view;
        ExprTimePeriodEvalDeltaConst timeDeltaComputation = this.timeDeltaComputationFactory.make(this.getViewName(), "view", agentInstanceContext, agentInstanceContext.getTimeAbacus());
        if (!timeDeltaComputation.equalsTimePeriod(myView.getTimeDeltaComputation())) {
            return false;
        }
        int size = ViewFactorySupport.evaluateSizeParam(this.getViewName(), this.sizeEvaluator, agentInstanceContext);
        if (myView.getNumberOfEvents() != (long)size) {
            return false;
        }
        if (myView.isForceOutput() != this.isForceUpdate) {
            return false;
        }
        if (myView.isStartEager()) {
            return false;
        }
        return myView.isEmpty();
    }

    @Override
    public String getViewName() {
        return "Time-Length-Batch";
    }
}

