/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.Envelope;

public class BinUtils {
    final long numCols;
    final double extentMin;
    final double extentMax;
    final double binSize;

    public BinUtils(double binSize) {
        this.binSize = binSize;
        long maxBinsPerAxis = (long)Math.sqrt(9.223372036854776E18);
        double size = binSize < 1.0 ? (double)maxBinsPerAxis * binSize : (double)maxBinsPerAxis;
        this.extentMax = size / 2.0;
        this.extentMin = this.extentMax - size;
        this.numCols = (long)Math.ceil(size / binSize);
    }

    public long getId(double x, double y) {
        double down = (this.extentMax - y) / this.binSize;
        double over = (x - this.extentMin) / this.binSize;
        return (long)down * this.numCols + (long)over;
    }

    public void queryEnvelope(long binId, Envelope envelope) {
        long down = binId / this.numCols;
        long over = binId % this.numCols;
        double xmin = this.extentMin + (double)over * this.binSize;
        double xmax = xmin + this.binSize;
        double ymax = this.extentMax - (double)down * this.binSize;
        double ymin = ymax - this.binSize;
        envelope.setCoords(xmin, ymin, xmax, ymax);
    }

    public void queryEnvelope(double x, double y, Envelope envelope) {
        double down = (this.extentMax - y) / this.binSize;
        double over = (x - this.extentMin) / this.binSize;
        double xmin = this.extentMin + over * this.binSize;
        double xmax = xmin + this.binSize;
        double ymax = this.extentMax - down * this.binSize;
        double ymin = ymax - this.binSize;
        envelope.setCoords(xmin, ymin, xmax, ymax);
    }
}

