/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_Aggr_ConvexHull", value="_FUNC_(ST_Geometry) - aggregate convex hull of all geometries passed", extended="Example:\n  SELECT _FUNC_(geometry) FROM source; -- return convex hull of all geometries in source")
public class ST_Aggr_ConvexHull
extends UDAF {
    static final Log LOG = LogFactory.getLog((String)ST_Aggr_ConvexHull.class.getName());

    public static class AggrConvexHullBinaryEvaluator
    implements UDAFEvaluator {
        private int MAX_BUFFER_SIZE = 1000;
        private ArrayList<Geometry> geometries = new ArrayList(this.MAX_BUFFER_SIZE);
        SpatialReference spatialRef = null;
        int firstWKID = -2;

        public void init() {
            if (this.geometries.size() > 0) {
                this.geometries.clear();
            }
        }

        public boolean iterate(BytesWritable geomref) throws HiveException {
            if (geomref == null) {
                LogUtils.Log_ArgumentsNull(LOG);
                return false;
            }
            if (this.firstWKID == -2) {
                this.firstWKID = GeometryUtils.getWKID(geomref);
                if (this.firstWKID != 0) {
                    this.spatialRef = SpatialReference.create((int)this.firstWKID);
                }
            } else if (this.firstWKID != GeometryUtils.getWKID(geomref)) {
                LogUtils.Log_SRIDMismatch(LOG, geomref, this.firstWKID);
                return false;
            }
            this.addGeometryToBuffer(geomref);
            return this.geometries.size() != 0;
        }

        public boolean merge(BytesWritable other) throws HiveException {
            return this.iterate(other);
        }

        public BytesWritable terminatePartial() throws HiveException {
            this.maybeAggregateBuffer(true);
            if (this.geometries.size() == 1) {
                OGCGeometry rslt = OGCGeometry.createFromEsriGeometry((Geometry)this.geometries.get(0), (SpatialReference)this.spatialRef);
                return GeometryUtils.geometryToEsriShapeBytesWritable(rslt);
            }
            return null;
        }

        public BytesWritable terminate() throws HiveException {
            return this.terminatePartial();
        }

        private void addGeometryToBuffer(BytesWritable geomref) throws HiveException {
            OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
            this.addGeometryToBuffer(ogcGeometry.getEsriGeometry());
        }

        private void addGeometryToBuffer(Geometry geom) throws HiveException {
            this.geometries.add(geom);
            this.maybeAggregateBuffer(false);
        }

        private void maybeAggregateBuffer(boolean force) throws HiveException {
            if (force || this.geometries.size() > this.MAX_BUFFER_SIZE) {
                Geometry[] geomArray = new Geometry[this.geometries.size()];
                this.geometries.toArray(geomArray);
                this.geometries.clear();
                try {
                    Geometry[] convexResult = GeometryEngine.convexHull((Geometry[])geomArray, (boolean)true);
                    Collections.addAll(this.geometries, convexResult);
                }
                catch (Exception e) {
                    LOG.error((Object)"exception thrown", (Throwable)e);
                }
            }
        }
    }
}

