/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.ListeningGeometryCursor;
import com.esri.core.geometry.OperatorUnion;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_Aggr_Union", value="_FUNC_(ST_Geometry) - aggregate union of all geometries passed", extended="Example:\n  SELECT _FUNC_(geometry) FROM source; -- return union of all geometries in source")
public class ST_Aggr_Union
extends UDAF {
    static final Log LOG = LogFactory.getLog((String)ST_Aggr_Union.class.getName());

    public static class AggrUnionBinaryEvaluator
    implements UDAFEvaluator {
        SpatialReference spatialRef = null;
        int firstWKID = -2;
        ListeningGeometryCursor lgc = null;
        GeometryCursor xgc = null;

        public void init() {
        }

        public boolean iterate(BytesWritable geomref) throws HiveException {
            if (geomref == null) {
                LogUtils.Log_ArgumentsNull(LOG);
                return false;
            }
            if (this.xgc == null) {
                this.firstWKID = GeometryUtils.getWKID(geomref);
                if (this.firstWKID != 0) {
                    this.spatialRef = SpatialReference.create((int)this.firstWKID);
                }
                this.lgc = new ListeningGeometryCursor();
                this.xgc = OperatorUnion.local().execute((GeometryCursor)this.lgc, this.spatialRef, null);
            } else if (this.firstWKID != GeometryUtils.getWKID(geomref)) {
                LogUtils.Log_SRIDMismatch(LOG, geomref, this.firstWKID);
                return false;
            }
            try {
                this.lgc.tick(GeometryUtils.geometryFromEsriShape(geomref).getEsriGeometry());
                this.xgc.tock();
                return true;
            }
            catch (Exception e) {
                LogUtils.Log_InternalError(LOG, "ST_Aggr_Union: " + e);
                return false;
            }
        }

        public boolean merge(BytesWritable other) throws HiveException {
            return this.iterate(other);
        }

        public BytesWritable terminatePartial() throws HiveException {
            try {
                Geometry rslt = this.xgc.next();
                this.lgc = null;
                this.xgc = null;
                OGCGeometry ogeom = OGCGeometry.createFromEsriGeometry((Geometry)rslt, (SpatialReference)this.spatialRef);
                return GeometryUtils.geometryToEsriShapeBytesWritable(ogeom);
            }
            catch (Exception e) {
                LogUtils.Log_InternalError(LOG, "ST_Aggr_Union: " + e);
                return null;
            }
        }

        public BytesWritable terminate() throws HiveException {
            return this.terminatePartial();
        }
    }
}

